/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.HoodieCleanStat;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineFactory;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.FileFormatUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.SparkHoodieIndexFactory;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.Assertions;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.apache.hudi.utils.HoodieWriterClientTestHarness;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieClientTestBase
extends HoodieSparkClientTestHarness {
    protected static final Logger LOG = LoggerFactory.getLogger(HoodieClientTestBase.class);

    @BeforeEach
    public void setUp() throws Exception {
        this.initResources();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanupResources();
    }

    public HoodieSparkTable getHoodieTable(HoodieTableMetaClient metaClient, HoodieWriteConfig config) {
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)config, (HoodieEngineContext)this.context, (HoodieTableMetaClient)metaClient);
        ((SyncableFileSystemView)table.getSliceView()).reset();
        return table;
    }

    public static void checkTaggedRecords(List<HoodieRecord> taggedRecords, String instantTime) {
        for (HoodieRecord rec : taggedRecords) {
            org.junit.jupiter.api.Assertions.assertTrue((boolean)rec.isCurrentLocationKnown(), (String)("Record " + rec + " found with no location."));
            org.junit.jupiter.api.Assertions.assertEquals((Object)rec.getCurrentLocation().getInstantTime(), (Object)instantTime, (String)("All records should have commit time " + instantTime + ", since updates were made"));
        }
    }

    public static HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer> wrapRecordsGenFunctionForPreppedCalls(String basePath, StorageConfiguration<?> storageConf, HoodieSparkEngineContext context, HoodieWriteConfig writeConfig, HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer> recordsGenFunction) {
        return (commit, numRecords) -> {
            HoodieIndex index = SparkHoodieIndexFactory.createIndex((HoodieWriteConfig)writeConfig);
            List records = (List)recordsGenFunction.apply(commit, numRecords);
            HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)storageConf, (String)basePath);
            HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)context, (HoodieTableMetaClient)metaClient);
            JavaRDD<HoodieRecord> taggedRecords = HoodieClientTestBase.tagLocation(index, (HoodieEngineContext)context, (JavaRDD<HoodieRecord>)context.getJavaSparkContext().parallelize(records, 1), (HoodieTable)table);
            return taggedRecords.collect();
        };
    }

    public static HoodieWriterClientTestHarness.Function3<List<HoodieRecord>, String, Integer, String> wrapPartitionRecordsGenFunctionForPreppedCalls(String basePath, StorageConfiguration<?> storageConf, HoodieSparkEngineContext context, HoodieWriteConfig writeConfig, HoodieWriterClientTestHarness.Function3<List<HoodieRecord>, String, Integer, String> recordsGenFunction) {
        return (commit, numRecords, partition) -> {
            HoodieIndex index = SparkHoodieIndexFactory.createIndex((HoodieWriteConfig)writeConfig);
            List records = (List)recordsGenFunction.apply(commit, numRecords, partition);
            HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)storageConf, (String)basePath);
            HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)context, (HoodieTableMetaClient)metaClient);
            JavaRDD<HoodieRecord> taggedRecords = HoodieClientTestBase.tagLocation(index, (HoodieEngineContext)context, (JavaRDD<HoodieRecord>)context.getJavaSparkContext().parallelize(records, 1), (HoodieTable)table);
            return taggedRecords.collect();
        };
    }

    public static java.util.function.Function<Integer, List<HoodieKey>> wrapDeleteKeysGenFunctionForPreppedCalls(String basePath, StorageConfiguration<?> storageConf, HoodieSparkEngineContext context, HoodieWriteConfig writeConfig, java.util.function.Function<Integer, List<HoodieKey>> keyGenFunction) {
        return numRecords -> {
            HoodieIndex index = SparkHoodieIndexFactory.createIndex((HoodieWriteConfig)writeConfig);
            List records = (List)keyGenFunction.apply((Integer)numRecords);
            HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)storageConf, (String)basePath);
            HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)writeConfig, (HoodieEngineContext)context, (HoodieTableMetaClient)metaClient);
            JavaRDD recordsToDelete = context.getJavaSparkContext().parallelize(records, 1).map((Function & Serializable)key -> new HoodieAvroRecord(key, (HoodieRecordPayload)new EmptyHoodieRecordPayload()));
            JavaRDD<HoodieRecord> taggedRecords = HoodieClientTestBase.tagLocation(index, (HoodieEngineContext)context, (JavaRDD<HoodieRecord>)recordsToDelete, (HoodieTable)table);
            return taggedRecords.map((Function & Serializable)record -> record.getKey()).collect();
        };
    }

    public HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer> generateWrapRecordsFn(boolean isPreppedAPI, HoodieWriteConfig writeConfig, HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer> wrapped) {
        if (isPreppedAPI) {
            return HoodieClientTestBase.wrapRecordsGenFunctionForPreppedCalls(this.basePath, this.storageConf, this.context, writeConfig, wrapped);
        }
        return wrapped;
    }

    public HoodieWriterClientTestHarness.Function3<List<HoodieRecord>, String, Integer, String> generateWrapRecordsForPartitionFn(boolean isPreppedAPI, HoodieWriteConfig writeConfig, HoodieWriterClientTestHarness.Function3<List<HoodieRecord>, String, Integer, String> wrapped) {
        if (isPreppedAPI) {
            return HoodieClientTestBase.wrapPartitionRecordsGenFunctionForPreppedCalls(this.basePath, this.storageConf, this.context, writeConfig, wrapped);
        }
        return wrapped;
    }

    public java.util.function.Function<Integer, List<HoodieKey>> generateWrapDeleteKeysFn(boolean isPreppedAPI, HoodieWriteConfig writeConfig, java.util.function.Function<Integer, List<HoodieKey>> wrapped) {
        if (isPreppedAPI) {
            return HoodieClientTestBase.wrapDeleteKeysGenFunctionForPreppedCalls(this.basePath, this.storageConf, this.context, writeConfig, wrapped);
        }
        return wrapped;
    }

    public JavaRDD<WriteStatus> insertFirstBatch(HoodieWriteConfig writeConfig, SparkRDDWriteClient client, String newCommitTime, String initCommitTime, int numRecordsInThisCommit, HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> writeFn, boolean isPreppedAPI, boolean assertForCommit, int expRecordsInThisCommit, InstantGenerator instantGenerator) throws Exception {
        return this.insertFirstBatch(writeConfig, client, newCommitTime, initCommitTime, numRecordsInThisCommit, writeFn, isPreppedAPI, assertForCommit, expRecordsInThisCommit, true, instantGenerator);
    }

    public JavaRDD<WriteStatus> insertFirstBatch(HoodieWriteConfig writeConfig, SparkRDDWriteClient client, String newCommitTime, String initCommitTime, int numRecordsInThisCommit, HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> writeFn, boolean isPreppedAPI, boolean assertForCommit, int expRecordsInThisCommit, boolean filterForCommitTimeWithAssert, InstantGenerator instantGenerator) throws Exception {
        HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer> recordGenFunction = this.generateWrapRecordsFn(isPreppedAPI, writeConfig, (HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer>)((HoodieWriterClientTestHarness.Function2)(arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1)));
        return this.writeBatch(client, newCommitTime, initCommitTime, (Option<List<String>>)Option.empty(), initCommitTime, numRecordsInThisCommit, recordGenFunction, writeFn, assertForCommit, expRecordsInThisCommit, expRecordsInThisCommit, 1, false, filterForCommitTimeWithAssert, instantGenerator);
    }

    public JavaRDD<WriteStatus> insertBatch(HoodieWriteConfig writeConfig, SparkRDDWriteClient client, String newCommitTime, String initCommitTime, int numRecordsInThisCommit, HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> writeFn, boolean isPreppedAPI, boolean assertForCommit, int expRecordsInThisCommit, int expTotalRecords, int expTotalCommits, Option<String> partition, InstantGenerator instantGenerator) throws Exception {
        if (partition.isPresent()) {
            HoodieWriterClientTestHarness.Function3<List<HoodieRecord>, String, Integer, String> recordGenFunction = this.generateWrapRecordsForPartitionFn(isPreppedAPI, writeConfig, (HoodieWriterClientTestHarness.Function3<List<HoodieRecord>, String, Integer, String>)((HoodieWriterClientTestHarness.Function3)(arg_0, arg_1, arg_2) -> ((HoodieTestDataGenerator)this.dataGen).generateInsertsForPartition(arg_0, arg_1, arg_2)));
            return this.writeBatch(client, newCommitTime, initCommitTime, (Option<List<String>>)Option.empty(), initCommitTime, numRecordsInThisCommit, recordGenFunction, writeFn, assertForCommit, expRecordsInThisCommit, expTotalRecords, expTotalCommits, false, (String)partition.get(), instantGenerator);
        }
        HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer> recordGenFunction = this.generateWrapRecordsFn(isPreppedAPI, writeConfig, (HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer>)((HoodieWriterClientTestHarness.Function2)(arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateInserts(arg_0, arg_1)));
        return this.writeBatch(client, newCommitTime, initCommitTime, (Option<List<String>>)Option.empty(), initCommitTime, numRecordsInThisCommit, recordGenFunction, writeFn, assertForCommit, expRecordsInThisCommit, expTotalRecords, expTotalCommits, false, instantGenerator);
    }

    public JavaRDD<WriteStatus> updateBatch(HoodieWriteConfig writeConfig, SparkRDDWriteClient client, String newCommitTime, String prevCommitTime, Option<List<String>> commitTimesBetweenPrevAndNew, String initCommitTime, int numRecordsInThisCommit, HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> writeFn, boolean isPreppedAPI, boolean assertForCommit, int expRecordsInThisCommit, int expTotalRecords, int expTotalCommits, InstantGenerator instantGenerator) throws Exception {
        return this.updateBatch(writeConfig, client, newCommitTime, prevCommitTime, commitTimesBetweenPrevAndNew, initCommitTime, numRecordsInThisCommit, writeFn, isPreppedAPI, assertForCommit, expRecordsInThisCommit, expTotalRecords, expTotalCommits, true, instantGenerator);
    }

    public JavaRDD<WriteStatus> updateBatch(HoodieWriteConfig writeConfig, SparkRDDWriteClient client, String newCommitTime, String prevCommitTime, Option<List<String>> commitTimesBetweenPrevAndNew, String initCommitTime, int numRecordsInThisCommit, HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> writeFn, boolean isPreppedAPI, boolean assertForCommit, int expRecordsInThisCommit, int expTotalRecords, int expTotalCommits, boolean filterForCommitTimeWithAssert, InstantGenerator instantGenerator) throws Exception {
        HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer> recordGenFunction = this.generateWrapRecordsFn(isPreppedAPI, writeConfig, (HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer>)((HoodieWriterClientTestHarness.Function2)(arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateUniqueUpdates(arg_0, arg_1)));
        return this.writeBatch(client, newCommitTime, prevCommitTime, commitTimesBetweenPrevAndNew, initCommitTime, numRecordsInThisCommit, recordGenFunction, writeFn, assertForCommit, expRecordsInThisCommit, expTotalRecords, expTotalCommits, false, filterForCommitTimeWithAssert, instantGenerator);
    }

    public JavaRDD<WriteStatus> deleteBatch(HoodieWriteConfig writeConfig, SparkRDDWriteClient client, String newCommitTime, String prevCommitTime, String initCommitTime, int numRecordsInThisCommit, boolean isPreppedAPI, boolean assertForCommit, int expRecordsInThisCommit, int expTotalRecords, TimelineFactory timelineFactory, InstantGenerator instantGenerator) throws Exception {
        return this.deleteBatch(writeConfig, client, newCommitTime, prevCommitTime, initCommitTime, numRecordsInThisCommit, isPreppedAPI, assertForCommit, expRecordsInThisCommit, expTotalRecords, true, timelineFactory, instantGenerator);
    }

    public JavaRDD<WriteStatus> deleteBatch(HoodieWriteConfig writeConfig, SparkRDDWriteClient client, String newCommitTime, String prevCommitTime, String initCommitTime, int numRecordsInThisCommit, boolean isPreppedAPI, boolean assertForCommit, int expRecordsInThisCommit, int expTotalRecords, boolean filterForCommitTimeWithAssert, TimelineFactory timelineFactory, InstantGenerator instantGenerator) throws Exception {
        if (isPreppedAPI) {
            HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer> recordGenFunction = this.generateWrapRecordsFn(isPreppedAPI, writeConfig, (HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer>)((HoodieWriterClientTestHarness.Function2)(arg_0, arg_1) -> ((HoodieTestDataGenerator)this.dataGen).generateUniqueDeleteRecords(arg_0, arg_1)));
            client.startCommitWithTime(newCommitTime);
            List records = (List)recordGenFunction.apply((Object)newCommitTime, (Object)numRecordsInThisCommit);
            JavaRDD deleteRecords = this.jsc.parallelize(records, 1);
            HoodieWriterClientTestHarness.Function3 deleteFn = SparkRDDWriteClient::deletePrepped;
            JavaRDD result = (JavaRDD)deleteFn.apply((Object)client, (Object)deleteRecords, (Object)newCommitTime);
            return this.getWriteStatusAndVerifyDeleteOperation(newCommitTime, prevCommitTime, initCommitTime, assertForCommit, expRecordsInThisCommit, expTotalRecords, filterForCommitTimeWithAssert, (JavaRDD<WriteStatus>)result, timelineFactory, instantGenerator);
        }
        java.util.function.Function<Integer, List<HoodieKey>> keyGenFunction = this.generateWrapDeleteKeysFn(isPreppedAPI, writeConfig, arg_0 -> ((HoodieTestDataGenerator)this.dataGen).generateUniqueDeletes(arg_0));
        client.startCommitWithTime(newCommitTime);
        List<HoodieKey> keysToDelete = keyGenFunction.apply(numRecordsInThisCommit);
        JavaRDD deleteRecords = this.jsc.parallelize(keysToDelete, 1);
        Assertions.assertPartitionMetadataForKeys((String)this.basePath, keysToDelete, (HoodieStorage)this.storage);
        HoodieWriterClientTestHarness.Function3 deleteFn = SparkRDDWriteClient::delete;
        JavaRDD result = (JavaRDD)deleteFn.apply((Object)client, (Object)deleteRecords, (Object)newCommitTime);
        return this.getWriteStatusAndVerifyDeleteOperation(newCommitTime, prevCommitTime, initCommitTime, assertForCommit, expRecordsInThisCommit, expTotalRecords, filterForCommitTimeWithAssert, (JavaRDD<WriteStatus>)result, timelineFactory, instantGenerator);
    }

    public JavaRDD<WriteStatus> writeBatch(SparkRDDWriteClient client, String newCommitTime, String prevCommitTime, Option<List<String>> commitTimesBetweenPrevAndNew, String initCommitTime, int numRecordsInThisCommit, HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer> recordGenFunction, HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> writeFn, boolean assertForCommit, int expRecordsInThisCommit, int expTotalRecords, int expTotalCommits, boolean doCommit, InstantGenerator instantGenerator) throws Exception {
        return this.writeBatch(client, newCommitTime, prevCommitTime, commitTimesBetweenPrevAndNew, initCommitTime, numRecordsInThisCommit, recordGenFunction, writeFn, assertForCommit, expRecordsInThisCommit, expTotalRecords, expTotalCommits, doCommit, true, instantGenerator);
    }

    public JavaRDD<WriteStatus> writeBatch(SparkRDDWriteClient client, String newCommitTime, String prevCommitTime, Option<List<String>> commitTimesBetweenPrevAndNew, String initCommitTime, int numRecordsInThisCommit, HoodieWriterClientTestHarness.Function3<List<HoodieRecord>, String, Integer, String> recordGenFunction, HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> writeFn, boolean assertForCommit, int expRecordsInThisCommit, int expTotalRecords, int expTotalCommits, boolean doCommit, String partition, InstantGenerator instantGenerator) throws Exception {
        return this.writeBatch(client, newCommitTime, prevCommitTime, commitTimesBetweenPrevAndNew, initCommitTime, numRecordsInThisCommit, recordGenFunction, writeFn, assertForCommit, expRecordsInThisCommit, expTotalRecords, expTotalCommits, doCommit, true, partition, instantGenerator);
    }

    public JavaRDD<WriteStatus> writeBatch(SparkRDDWriteClient client, String newCommitTime, String prevCommitTime, Option<List<String>> commitTimesBetweenPrevAndNew, String initCommitTime, int numRecordsInThisCommit, HoodieWriterClientTestHarness.Function2<List<HoodieRecord>, String, Integer> recordGenFunction, HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> writeFn, boolean assertForCommit, int expRecordsInThisCommit, int expTotalRecords, int expTotalCommits, boolean doCommit, boolean filterForCommitTimeWithAssert, InstantGenerator instantGenerator) throws Exception {
        List records = (List)recordGenFunction.apply((Object)newCommitTime, (Object)numRecordsInThisCommit);
        return this.writeBatchHelper(client, newCommitTime, prevCommitTime, commitTimesBetweenPrevAndNew, initCommitTime, numRecordsInThisCommit, records, writeFn, assertForCommit, expRecordsInThisCommit, expTotalRecords, expTotalCommits, doCommit, filterForCommitTimeWithAssert, instantGenerator);
    }

    public JavaRDD<WriteStatus> writeBatch(SparkRDDWriteClient client, String newCommitTime, String prevCommitTime, Option<List<String>> commitTimesBetweenPrevAndNew, String initCommitTime, int numRecordsInThisCommit, HoodieWriterClientTestHarness.Function3<List<HoodieRecord>, String, Integer, String> recordGenFunction, HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> writeFn, boolean assertForCommit, int expRecordsInThisCommit, int expTotalRecords, int expTotalCommits, boolean doCommit, boolean filterForCommitTimeWithAssert, String partition, InstantGenerator instantGenerator) throws Exception {
        List records = (List)recordGenFunction.apply((Object)newCommitTime, (Object)numRecordsInThisCommit, (Object)partition);
        return this.writeBatchHelper(client, newCommitTime, prevCommitTime, commitTimesBetweenPrevAndNew, initCommitTime, numRecordsInThisCommit, records, writeFn, assertForCommit, expRecordsInThisCommit, expTotalRecords, expTotalCommits, doCommit, filterForCommitTimeWithAssert, instantGenerator);
    }

    private JavaRDD<WriteStatus> writeBatchHelper(SparkRDDWriteClient client, String newCommitTime, String prevCommitTime, Option<List<String>> commitTimesBetweenPrevAndNew, String initCommitTime, int numRecordsInThisCommit, List<HoodieRecord> records, HoodieWriterClientTestHarness.Function3<JavaRDD<WriteStatus>, SparkRDDWriteClient, JavaRDD<HoodieRecord>, String> writeFn, boolean assertForCommit, int expRecordsInThisCommit, int expTotalRecords, int expTotalCommits, boolean doCommit, boolean filterForCommitTimeWithAssert, InstantGenerator instantGenerator) throws IOException {
        client.startCommitWithTime(newCommitTime);
        JavaRDD writeRecords = this.jsc.parallelize(records, 1);
        JavaRDD result = (JavaRDD)writeFn.apply((Object)client, (Object)writeRecords, (Object)newCommitTime);
        List statuses = result.collect();
        Assertions.assertNoWriteErrors((List)statuses);
        if (doCommit) {
            client.commit(newCommitTime, (Object)result);
        }
        Assertions.assertPartitionMetadataForRecords((String)this.basePath, records, (HoodieStorage)this.storage);
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)this.storageConf, (String)this.basePath);
        HoodieTimeline timeline = metaClient.getCommitsTimeline();
        if (assertForCommit) {
            org.junit.jupiter.api.Assertions.assertEquals((int)expTotalCommits, (int)timeline.findInstantsAfter(initCommitTime, Integer.MAX_VALUE).countInstants(), (String)("Expecting " + expTotalCommits + " commits."));
            org.junit.jupiter.api.Assertions.assertEquals((Object)newCommitTime, (Object)((HoodieInstant)timeline.lastInstant().get()).requestedTime(), (String)("Latest commit should be " + newCommitTime));
            if (filterForCommitTimeWithAssert) {
                org.junit.jupiter.api.Assertions.assertEquals((long)expRecordsInThisCommit, (long)HoodieClientTestUtils.readCommit(this.basePath, this.sqlContext, timeline, newCommitTime, true, instantGenerator).count(), (String)("Must contain " + expRecordsInThisCommit + " records"));
            }
            String[] fullPartitionPaths = new String[this.dataGen.getPartitionPaths().length];
            for (int i = 0; i < fullPartitionPaths.length; ++i) {
                fullPartitionPaths[i] = String.format("%s/%s/*", this.basePath, this.dataGen.getPartitionPaths()[i]);
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)expTotalRecords, (long)HoodieClientTestUtils.read(this.jsc, this.basePath, this.sqlContext, this.storage, fullPartitionPaths).count(), (String)("Must contain " + expTotalRecords + " records"));
            if (filterForCommitTimeWithAssert) {
                org.junit.jupiter.api.Assertions.assertEquals((long)HoodieClientTestUtils.readCommit(this.basePath, this.sqlContext, timeline, newCommitTime, true, instantGenerator).count(), (long)HoodieClientTestUtils.countRecordsOptionallySince(this.jsc, this.basePath, this.sqlContext, timeline, (Option<String>)Option.of((Object)prevCommitTime)), (String)("Incremental consumption from " + prevCommitTime + " should give all records in latest commit"));
                if (commitTimesBetweenPrevAndNew.isPresent()) {
                    ((List)commitTimesBetweenPrevAndNew.get()).forEach(ct -> org.junit.jupiter.api.Assertions.assertEquals((long)HoodieClientTestUtils.readCommit(this.basePath, this.sqlContext, timeline, newCommitTime, true, instantGenerator).count(), (long)HoodieClientTestUtils.countRecordsOptionallySince(this.jsc, this.basePath, this.sqlContext, timeline, (Option<String>)Option.of((Object)ct)), (String)("Incremental consumption from " + ct + " should give all records in latest commit")));
                }
            }
        }
        return result;
    }

    private JavaRDD<WriteStatus> getWriteStatusAndVerifyDeleteOperation(String newCommitTime, String prevCommitTime, String initCommitTime, boolean assertForCommit, int expRecordsInThisCommit, int expTotalRecords, boolean filerForCommitTimeWithAssert, JavaRDD<WriteStatus> result, TimelineFactory timelineFactory, InstantGenerator instantGenerator) {
        List statuses = result.collect();
        Assertions.assertNoWriteErrors((List)statuses);
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient((StorageConfiguration)this.storageConf, (String)this.basePath);
        HoodieTimeline timeline = timelineFactory.createActiveTimeline(metaClient).getCommitAndReplaceTimeline();
        if (assertForCommit) {
            org.junit.jupiter.api.Assertions.assertEquals((int)3, (int)timeline.findInstantsAfter(initCommitTime, Integer.MAX_VALUE).countInstants(), (String)"Expecting 3 commits.");
            org.junit.jupiter.api.Assertions.assertEquals((Object)newCommitTime, (Object)((HoodieInstant)timeline.lastInstant().get()).requestedTime(), (String)("Latest commit should be " + newCommitTime));
            if (filerForCommitTimeWithAssert) {
                org.junit.jupiter.api.Assertions.assertEquals((long)expRecordsInThisCommit, (long)HoodieClientTestUtils.readCommit(this.basePath, this.sqlContext, timeline, newCommitTime, true, instantGenerator).count(), (String)("Must contain " + expRecordsInThisCommit + " records"));
            }
            String[] fullPartitionPaths = new String[this.dataGen.getPartitionPaths().length];
            for (int i = 0; i < fullPartitionPaths.length; ++i) {
                fullPartitionPaths[i] = String.format("%s/%s/*", this.basePath, this.dataGen.getPartitionPaths()[i]);
            }
            org.junit.jupiter.api.Assertions.assertEquals((long)expTotalRecords, (long)HoodieClientTestUtils.read(this.jsc, this.basePath, this.sqlContext, this.storage, fullPartitionPaths).count(), (String)("Must contain " + expTotalRecords + " records"));
            if (filerForCommitTimeWithAssert) {
                org.junit.jupiter.api.Assertions.assertEquals((long)HoodieClientTestUtils.readCommit(this.basePath, this.sqlContext, timeline, newCommitTime, true, instantGenerator).count(), (long)HoodieClientTestUtils.countRecordsOptionallySince(this.jsc, this.basePath, this.sqlContext, timeline, (Option<String>)Option.of((Object)prevCommitTime)), (String)("Incremental consumption from " + prevCommitTime + " should give no records in latest commit, since it is a delete operation"));
            }
        }
        return result;
    }

    protected void insertBatchWithoutCommit(String newCommitTime, int numRecords) {
        HoodieWriteConfig hoodieWriteConfig = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.LAZY).withAutoCommit(false).withRollbackUsingMarkers(true).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(hoodieWriteConfig);){
            client.startCommitWithTime(newCommitTime);
            List records = this.dataGen.generateInserts(newCommitTime, Integer.valueOf(numRecords));
            JavaRDD writeRecords = this.jsc.parallelize(records, 1);
            List statuses = client.insert(writeRecords, newCommitTime).collect();
            Assertions.assertNoWriteErrors((List)statuses);
        }
    }

    protected void updateBatchWithoutCommit(String newCommitTime, List<HoodieRecord> baseRecordsToUpdate) throws IOException {
        HoodieWriteConfig hoodieWriteConfig = this.getConfigBuilder(HoodieFailedWritesCleaningPolicy.LAZY).withAutoCommit(false).withRollbackUsingMarkers(true).withHeartbeatTolerableMisses(Integer.valueOf(0)).build();
        try (SparkRDDWriteClient client = this.getHoodieWriteClient(hoodieWriteConfig);){
            client.startCommitWithTime(newCommitTime);
            List records = this.dataGen.generateUpdates(newCommitTime, baseRecordsToUpdate);
            JavaRDD writeRecords = this.jsc.parallelize(records, 1);
            client.upsert(writeRecords, newCommitTime);
        }
    }

    protected void assertRowNumberEqualsTo(int numRows) {
        String[] fullPartitionPaths = new String[this.dataGen.getPartitionPaths().length];
        for (int i = 0; i < fullPartitionPaths.length; ++i) {
            fullPartitionPaths[i] = String.format("%s/%s/*", this.basePath, this.dataGen.getPartitionPaths()[i]);
        }
        org.junit.jupiter.api.Assertions.assertEquals((long)numRows, (long)HoodieClientTestUtils.read(this.jsc, this.basePath, this.sqlContext, this.storage, fullPartitionPaths).count(), (String)("Must contain " + numRows + " records"));
    }

    public HoodieCleanStat getCleanStat(List<HoodieCleanStat> hoodieCleanStatsTwo, String partitionPath) {
        return hoodieCleanStatsTwo.stream().filter(e -> e.getPartitionPath().equals(partitionPath)).findFirst().orElse(null);
    }

    public static FileFormatUtils getFileUtilsInstance(HoodieTableMetaClient metaClient) {
        return HoodieIOFactory.getIOFactory((HoodieStorage)metaClient.getStorage()).getFileFormatUtils(metaClient.getTableConfig().getBaseFileFormat());
    }
}

