/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.apache.spark.sql.HoodieDataTypeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class TestHoodieDataTypeUtils {
    private static final Schema SMALL_DECIMAL_SCHEMA = LogicalTypes.decimal((int)18, (int)10).addToSchema(Schema.createFixed((String)"smallDec", null, (String)"org.apache.hudi.test", (int)9));
    private static final Schema LARGE_DECIMAL_SCHEMA = LogicalTypes.decimal((int)20, (int)10).addToSchema(Schema.createFixed((String)"largeDec", null, (String)"org.apache.hudi.test", (int)9));

    TestHoodieDataTypeUtils() {
    }

    private static Stream<Arguments> canUseRowWriterCases() {
        Schema listSchema = Schema.createArray((Schema)Schema.create((Schema.Type)Schema.Type.INT));
        Schema mapSchema = Schema.createMap((Schema)Schema.create((Schema.Type)Schema.Type.INT));
        Schema schemaWithSmallDecimal = Schema.createRecord((String)"schemaWithSmallDecimal", null, null, (boolean)false, Collections.singletonList(new Schema.Field("smallDecimal", SMALL_DECIMAL_SCHEMA, null, null)));
        Schema schemaWithSmallDecimalAndList = Schema.createRecord((String)"schemaWithSmallDecimalAndList", null, null, (boolean)false, Arrays.asList(new Schema.Field("smallDecimal", SMALL_DECIMAL_SCHEMA, null, null), new Schema.Field("intField", Schema.create((Schema.Type)Schema.Type.INT), null, null), new Schema.Field("listField", listSchema, null, null)));
        Schema schemaWithSmallDecimalAndMap = Schema.createRecord((String)"schemaWithSmallDecimalAndMap", null, null, (boolean)false, Arrays.asList(new Schema.Field("smallDecimal", SMALL_DECIMAL_SCHEMA, null, null), new Schema.Field("intField", Schema.create((Schema.Type)Schema.Type.INT), null, null), new Schema.Field("mapField", mapSchema, null, null)));
        Schema schemaWithLargeDecimalAndList = Schema.createRecord((String)"schemaWithLargeDecimalAndList", null, null, (boolean)false, Arrays.asList(new Schema.Field("largeDecimal", LARGE_DECIMAL_SCHEMA, null, null), new Schema.Field("intField", Schema.create((Schema.Type)Schema.Type.INT), null, null), new Schema.Field("listField", listSchema, null, null)));
        Schema schemaWithLargeDecimalAndMap = Schema.createRecord((String)"schemaWithLargeDecimalAndMap", null, null, (boolean)false, Arrays.asList(new Schema.Field("largeDecimal", LARGE_DECIMAL_SCHEMA, null, null), new Schema.Field("intField", Schema.create((Schema.Type)Schema.Type.INT), null, null), new Schema.Field("mapField", mapSchema, null, null)));
        Schema schemaWithoutSpecialTypes = Schema.createRecord((String)"schemaWithInt", null, null, (boolean)false, Collections.singletonList(new Schema.Field("intField", Schema.create((Schema.Type)Schema.Type.INT), null, null)));
        Configuration configurationWithLegacyListFormat = new Configuration(false);
        configurationWithLegacyListFormat.set("parquet.avro.write-old-list-structure", "true");
        Configuration configurationWithoutLegacyListFormat = new Configuration(false);
        configurationWithoutLegacyListFormat.set("parquet.avro.write-old-list-structure", "false");
        return Stream.of(Arguments.of((Object[])new Object[]{schemaWithoutSpecialTypes, configurationWithoutLegacyListFormat, true}), Arguments.of((Object[])new Object[]{schemaWithSmallDecimal, configurationWithoutLegacyListFormat, true}), Arguments.of((Object[])new Object[]{schemaWithLargeDecimalAndMap, configurationWithoutLegacyListFormat, true}), Arguments.of((Object[])new Object[]{schemaWithSmallDecimalAndMap, configurationWithoutLegacyListFormat, false}), Arguments.of((Object[])new Object[]{schemaWithLargeDecimalAndMap, configurationWithoutLegacyListFormat, true}), Arguments.of((Object[])new Object[]{schemaWithSmallDecimalAndList, configurationWithLegacyListFormat, true}), Arguments.of((Object[])new Object[]{schemaWithSmallDecimalAndList, configurationWithoutLegacyListFormat, false}), Arguments.of((Object[])new Object[]{schemaWithLargeDecimalAndList, configurationWithoutLegacyListFormat, true}), Arguments.of((Object[])new Object[]{schemaWithLargeDecimalAndList, configurationWithLegacyListFormat, true}));
    }

    @ParameterizedTest
    @MethodSource(value={"canUseRowWriterCases"})
    void testCanUseRowWriter(Schema schema, Configuration conf, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)HoodieDataTypeUtils.canUseRowWriter((Schema)schema, (Configuration)conf));
    }

    private static Stream<Arguments> testAutoModifyParquetWriteLegacyFormatParameterParams() {
        return Arrays.stream(new Object[][]{{true, null, true}, {false, null, null}, {true, false, false}, {true, true, true}, {false, true, true}, {false, false, false}}).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"testAutoModifyParquetWriteLegacyFormatParameterParams"})
    void testAutoModifyParquetWriteLegacyFormatParameter(boolean smallDecimal, Boolean propValue, Boolean expectedPropValue) {
        Schema decimalType = smallDecimal ? SMALL_DECIMAL_SCHEMA : LARGE_DECIMAL_SCHEMA;
        Schema schema = Schema.createRecord((String)"test", null, null, (boolean)false, Collections.singletonList(new Schema.Field("decimalField", decimalType, null, null)));
        TypedProperties options = propValue != null ? TypedProperties.fromMap(Collections.singletonMap(HoodieStorageConfig.PARQUET_WRITE_LEGACY_FORMAT_ENABLED.key(), String.valueOf(propValue))) : new TypedProperties();
        HoodieDataTypeUtils.tryOverrideParquetWriteLegacyFormatProperty((TypedProperties)options, (Schema)schema);
        Boolean finalPropValue = (Boolean)Option.ofNullable((Object)options.get((Object)HoodieStorageConfig.PARQUET_WRITE_LEGACY_FORMAT_ENABLED.key())).map(value -> Boolean.parseBoolean(value.toString())).orElse(null);
        Assertions.assertEquals((Object)expectedPropValue, (Object)finalPropValue);
    }
}

