/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.execution;

import java.util.Arrays;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.hudi.util.JavaScalaConverters;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.hudi.execution.RangeSampleSort$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestRangeSampleSort
extends HoodieClientTestBase {
    TestRangeSampleSort() {
    }

    @Test
    void sortDataFrameBySampleSupportAllTypes() {
        Dataset df = this.context.getSqlContext().sql("select 1 as id, array(2) as content");
        int i = 0;
        while (i < 2) {
            int limit = i++;
            Assertions.assertDoesNotThrow(() -> RangeSampleSort$.MODULE$.sortDataFrameBySampleSupportAllTypes(df.limit(limit), JavaScalaConverters.convertJavaListToScalaSeq(Arrays.asList("id", "content")), 1), (String)"range sort shall not fail when 0 or 1 record incoming");
        }
    }

    @Test
    void sortDataFrameBySample() {
        HoodieClusteringConfig.LayoutOptimizationStrategy layoutOptStrategy = HoodieClusteringConfig.LayoutOptimizationStrategy.HILBERT;
        Dataset df = this.context.getSqlContext().sql("select 1 as id, 2 as content");
        int i = 0;
        while (i < 2) {
            int limit = i++;
            Assertions.assertDoesNotThrow(() -> RangeSampleSort$.MODULE$.sortDataFrameBySample(df.limit(limit), layoutOptStrategy, JavaScalaConverters.convertJavaListToScalaSeq(Arrays.asList("id", "content")), 1), (String)"range sort shall not fail when 0 or 1 record incoming");
        }
    }
}

