/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.IOException;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.HoodieSparkRecordMerger;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieSparkRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.merge.SparkRecordMergingUtils;

public class DefaultSparkRecordMerger
extends HoodieSparkRecordMerger {
    public String getMergingStrategy() {
        return "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5";
    }

    public Option<Pair<HoodieRecord, Schema>> merge(HoodieRecord older, Schema oldSchema, HoodieRecord newer, Schema newSchema, TypedProperties props) throws IOException {
        HoodieSparkRecord oldSparkRecord;
        HoodieSparkRecord newSparkRecord;
        ValidationUtils.checkArgument((older.getRecordType() == HoodieRecord.HoodieRecordType.SPARK ? 1 : 0) != 0);
        ValidationUtils.checkArgument((newer.getRecordType() == HoodieRecord.HoodieRecordType.SPARK ? 1 : 0) != 0);
        if (newer instanceof HoodieSparkRecord ? (newSparkRecord = (HoodieSparkRecord)newer).isDelete(newSchema, (Properties)props) : newer.getData() == null) {
            return Option.empty();
        }
        if (older instanceof HoodieSparkRecord ? (oldSparkRecord = (HoodieSparkRecord)older).isDelete(oldSchema, (Properties)props) : older.getData() == null) {
            return Option.of((Object)Pair.of((Object)newer, (Object)newSchema));
        }
        if (older.getOrderingValue(oldSchema, (Properties)props).compareTo(newer.getOrderingValue(newSchema, (Properties)props)) > 0) {
            return Option.of((Object)Pair.of((Object)older, (Object)oldSchema));
        }
        return Option.of((Object)Pair.of((Object)newer, (Object)newSchema));
    }

    public Option<Pair<HoodieRecord, Schema>> partialMerge(HoodieRecord older, Schema oldSchema, HoodieRecord newer, Schema newSchema, Schema readerSchema, TypedProperties props) throws IOException {
        HoodieSparkRecord oldSparkRecord;
        HoodieSparkRecord newSparkRecord;
        ValidationUtils.checkArgument((older.getRecordType() == HoodieRecord.HoodieRecordType.SPARK ? 1 : 0) != 0);
        ValidationUtils.checkArgument((newer.getRecordType() == HoodieRecord.HoodieRecordType.SPARK ? 1 : 0) != 0);
        if (newer instanceof HoodieSparkRecord ? (newSparkRecord = (HoodieSparkRecord)newer).isDelete(newSchema, (Properties)props) : newer.getData() == null) {
            return Option.empty();
        }
        if (older instanceof HoodieSparkRecord ? (oldSparkRecord = (HoodieSparkRecord)older).isDelete(oldSchema, (Properties)props) : older.getData() == null) {
            return Option.of((Object)Pair.of((Object)newer, (Object)newSchema));
        }
        if (older.getOrderingValue(oldSchema, (Properties)props).compareTo(newer.getOrderingValue(newSchema, (Properties)props)) > 0) {
            return Option.of(SparkRecordMergingUtils.mergePartialRecords((HoodieSparkRecord)newer, newSchema, (HoodieSparkRecord)older, oldSchema, readerSchema, props));
        }
        return Option.of(SparkRecordMergingUtils.mergePartialRecords((HoodieSparkRecord)older, oldSchema, (HoodieSparkRecord)newer, newSchema, readerSchema, props));
    }
}

