/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.bootstrap;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieFileStatus;
import org.apache.hudi.avro.model.HoodiePath;
import org.apache.hudi.client.bootstrap.HoodieBootstrapSchemaProvider;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.util.AvroOrcUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;

public class HoodieSparkBootstrapSchemaProvider
extends HoodieBootstrapSchemaProvider {
    public HoodieSparkBootstrapSchemaProvider(HoodieWriteConfig writeConfig) {
        super(writeConfig);
    }

    protected Schema getBootstrapSourceSchema(HoodieEngineContext context, List<Pair<String, List<HoodieFileStatus>>> partitions) {
        Schema schema = partitions.stream().flatMap(p -> ((List)p.getValue()).stream()).map(fs -> {
            Path filePath = HadoopFSUtils.toPath((HoodiePath)fs.getPath());
            String extension = FSUtils.getFileExtension((String)filePath.getName());
            if (HoodieFileFormat.PARQUET.getFileExtension().equals(extension)) {
                return HoodieSparkBootstrapSchemaProvider.getBootstrapSourceSchemaParquet(this.writeConfig, context, filePath);
            }
            if (HoodieFileFormat.ORC.getFileExtension().equals(extension)) {
                return HoodieSparkBootstrapSchemaProvider.getBootstrapSourceSchemaOrc(this.writeConfig, context, filePath);
            }
            throw new HoodieException("Could not determine schema from the data files, supported file formats: [ORC, PARQUET].");
        }).filter(Objects::nonNull).findAny().orElseThrow(() -> new HoodieException("Could not determine schema from the data files."));
        return schema;
    }

    private static Schema getBootstrapSourceSchemaParquet(HoodieWriteConfig writeConfig, HoodieEngineContext context, Path filePath) {
        ((HoodieSparkEngineContext)context).getSqlContext().setConf(SQLConf.PARTITION_COLUMN_TYPE_INFERENCE(), (Object)false);
        StructType parquetSchema = ((HoodieSparkEngineContext)context).getSqlContext().read().option("basePath", writeConfig.getBootstrapSourceBasePath()).parquet(filePath.toString()).schema();
        String tableName = HoodieAvroUtils.sanitizeName((String)writeConfig.getTableName());
        String structName = tableName + "_record";
        String recordNamespace = "hoodie." + tableName;
        return AvroConversionUtils.convertStructTypeToAvroSchema((DataType)parquetSchema, structName, recordNamespace);
    }

    private static Schema getBootstrapSourceSchemaOrc(HoodieWriteConfig writeConfig, HoodieEngineContext context, Path filePath) {
        Reader orcReader = null;
        try {
            orcReader = OrcFile.createReader((Path)filePath, (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)((Configuration)context.getStorageConf().unwrapAs(Configuration.class))));
        }
        catch (IOException e) {
            throw new HoodieException("Could not determine schema from the ORC data files.");
        }
        TypeDescription orcSchema = orcReader.getSchema();
        String tableName = HoodieAvroUtils.sanitizeName((String)writeConfig.getTableName());
        String structName = tableName + "_record";
        String recordNamespace = "hoodie." + tableName;
        return AvroOrcUtils.createAvroSchemaWithDefaultValue((TypeDescription)orcSchema, (String)structName, (String)recordNamespace, (boolean)true);
    }
}

