/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.SortUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;

public class RDDCustomColumnsSortPartitioner<T>
implements BulkInsertPartitioner<JavaRDD<HoodieRecord<T>>> {
    private final String[] sortColumnNames;
    private final SerializableSchema serializableSchema;
    private final boolean consistentLogicalTimestampEnabled;
    private final boolean suffixRecordKey;

    public RDDCustomColumnsSortPartitioner(HoodieWriteConfig config) {
        this.serializableSchema = new SerializableSchema(new Schema.Parser().parse(config.getSchema()));
        this.sortColumnNames = this.getSortColumnName(config);
        this.consistentLogicalTimestampEnabled = config.isConsistentLogicalTimestampEnabled();
        this.suffixRecordKey = config.getBoolean(HoodieWriteConfig.BULKINSERT_SUFFIX_RECORD_KEY_SORT_COLUMNS);
    }

    public RDDCustomColumnsSortPartitioner(String[] columnNames, Schema schema, HoodieWriteConfig config) {
        this.sortColumnNames = columnNames;
        this.serializableSchema = new SerializableSchema(schema);
        this.consistentLogicalTimestampEnabled = config.isConsistentLogicalTimestampEnabled();
        this.suffixRecordKey = config.getBoolean(HoodieWriteConfig.BULKINSERT_SUFFIX_RECORD_KEY_SORT_COLUMNS);
    }

    public JavaRDD<HoodieRecord<T>> repartitionRecords(JavaRDD<HoodieRecord<T>> records, int outputSparkPartitions) {
        return records.sortBy((Function & Serializable)record -> SortUtils.getComparableSortColumns((HoodieRecord)record, (String[])this.sortColumnNames, (Schema)this.serializableSchema.get(), (boolean)this.suffixRecordKey, (boolean)this.consistentLogicalTimestampEnabled), true, outputSparkPartitions);
    }

    public boolean arePartitionRecordsSorted() {
        return true;
    }

    private String[] getSortColumnName(HoodieWriteConfig config) {
        return (String[])Arrays.stream(config.getUserDefinedBulkInsertPartitionerSortColumns().split(",")).map(String::trim).toArray(String[]::new);
    }
}

