/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.execution.bulkinsert.RDDBucketIndexPartitioner;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.index.bucket.HoodieSimpleBucketIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaRDD;

public class RDDSimpleBucketBulkInsertPartitioner<T extends HoodieRecordPayload>
extends RDDBucketIndexPartitioner<T> {
    private final boolean isNonBlockingConcurrencyControl;

    public RDDSimpleBucketBulkInsertPartitioner(HoodieTable table) {
        super(table, null, false);
        ValidationUtils.checkArgument((boolean)(table.getIndex() instanceof HoodieSimpleBucketIndex));
        this.isNonBlockingConcurrencyControl = table.getConfig().isNonBlockingConcurrencyControl();
    }

    public JavaRDD<HoodieRecord<T>> repartitionRecords(JavaRDD<HoodieRecord<T>> records, int outputPartitions) {
        final HoodieSimpleBucketIndex index = (HoodieSimpleBucketIndex)this.table.getIndex();
        final HashMap<String, Integer> fileIdPrefixToBucketIndex = new HashMap<String, Integer>();
        final Map<String, Map<Integer, String>> partitionMapper = this.getPartitionMapper(records, fileIdPrefixToBucketIndex);
        return this.doPartition(records, new Partitioner(){

            public int numPartitions() {
                return index.getNumBuckets() * partitionMapper.size();
            }

            public int getPartition(Object key) {
                HoodieKey hoodieKey = (HoodieKey)key;
                String partitionPath = hoodieKey.getPartitionPath();
                int bucketID = index.getBucketID(hoodieKey);
                String fileID = (String)((Map)partitionMapper.get(partitionPath)).get(bucketID);
                return (Integer)fileIdPrefixToBucketIndex.get(fileID);
            }
        });
    }

    Map<String, Map<Integer, String>> getPartitionMapper(JavaRDD<HoodieRecord<T>> records, Map<String, Integer> fileIdPrefixToBucketIndex) {
        HoodieSimpleBucketIndex index = (HoodieSimpleBucketIndex)this.table.getIndex();
        int numBuckets = index.getNumBuckets();
        return records.map(HoodieRecord::getPartitionPath).distinct().collect().stream().collect(Collectors.toMap(p -> p, p -> {
            Map locationMap = index.loadBucketIdToFileIdMappingForPartition(this.table, p);
            HashMap<Integer, String> bucketIdToFileIdPrefixMap = new HashMap<Integer, String>();
            HashSet existsBucketID = new HashSet();
            locationMap.forEach((k, v) -> {
                String prefix = FSUtils.getFileIdPfxFromFileId((String)v.getFileId());
                bucketIdToFileIdPrefixMap.put((Integer)k, prefix);
                fileIdPrefixToBucketIndex.put(prefix, this.fileIdPfxList.size());
                this.fileIdPfxList.add(prefix);
                existsBucketID.add(BucketIdentifier.bucketIdFromFileId((String)prefix));
                this.doAppend.add(true);
            });
            for (int i = 0; i < numBuckets; ++i) {
                if (existsBucketID.contains(i)) continue;
                String fileIdPrefix = BucketIdentifier.newBucketFileIdPrefix((int)i, (boolean)this.isNonBlockingConcurrencyControl);
                fileIdPrefixToBucketIndex.put(fileIdPrefix, this.fileIdPfxList.size());
                this.fileIdPfxList.add(fileIdPrefix);
                this.doAppend.add(false);
                bucketIdToFileIdPrefixMap.put(i, fileIdPrefix);
            }
            return bucketIdToFileIdPrefixMap;
        }));
    }
}

