/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.ConsistentHashingNode;
import org.apache.hudi.common.model.HoodieConsistentHashingMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.exception.HoodieIndexException;
import org.apache.hudi.index.bucket.ConsistentBucketIdentifier;
import org.apache.hudi.index.bucket.ConsistentBucketIndexUtils;
import org.apache.hudi.index.bucket.HoodieConsistentBucketIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.api.java.function.VoidFunction;
import scala.Tuple2;

public class HoodieSparkConsistentBucketIndex
extends HoodieConsistentBucketIndex {
    public HoodieSparkConsistentBucketIndex(HoodieWriteConfig config) {
        super(config);
    }

    public HoodieData<WriteStatus> updateLocation(HoodieData<WriteStatus> writeStatuses, HoodieEngineContext context, HoodieTable hoodieTable, String instantTime) throws HoodieIndexException {
        HoodieInstant instant = (HoodieInstant)hoodieTable.getMetaClient().getActiveTimeline().findInstantsAfterOrEquals(instantTime, 1).firstInstant().get();
        ValidationUtils.checkState((boolean)instant.requestedTime().equals(instantTime), (String)("Cannot get the same instant, instantTime: " + instantTime));
        if (!ClusteringUtils.isClusteringOrReplaceCommitAction((String)instant.getAction())) {
            return writeStatuses;
        }
        Option instantPlanPair = ClusteringUtils.getClusteringPlan((HoodieTableMetaClient)hoodieTable.getMetaClient(), (HoodieInstant)instant);
        if (!instantPlanPair.isPresent()) {
            return writeStatuses;
        }
        HoodieClusteringPlan plan = (HoodieClusteringPlan)((Pair)instantPlanPair.get()).getRight();
        HoodieJavaRDD.getJavaRDD(context.parallelize(plan.getInputGroups().stream().map(HoodieClusteringGroup::getExtraMetadata).collect(Collectors.toList()))).mapToPair((PairFunction & Serializable)m -> new Tuple2(m.get("clustering.group.partition"), m)).groupByKey().foreach((VoidFunction & Serializable)input -> {
            String partition = (String)input._1();
            ArrayList childNodes = new ArrayList();
            int seqNo = 0;
            for (Map m : (Iterable)input._2()) {
                String nodesJson = (String)m.get("clustering.group.child.node");
                childNodes.addAll(ConsistentHashingNode.fromJsonString((String)nodesJson));
                seqNo = Integer.parseInt((String)m.get("clustering.group.sequence.no"));
            }
            Option metadataOption = ConsistentBucketIndexUtils.loadMetadata((HoodieTable)hoodieTable, (String)partition);
            ValidationUtils.checkState((boolean)metadataOption.isPresent(), (String)("Failed to load metadata for partition: " + partition));
            HoodieConsistentHashingMetadata meta = (HoodieConsistentHashingMetadata)metadataOption.get();
            ValidationUtils.checkState((meta.getSeqNo() == seqNo ? 1 : 0) != 0, (String)("Non serialized update to hashing metadata, old seq: " + meta.getSeqNo() + ", new seq: " + seqNo));
            meta.setChildrenNodes(childNodes);
            List newNodes = new ConsistentBucketIdentifier(meta).getNodes().stream().map(n -> new ConsistentHashingNode(n.getValue(), n.getFileIdPrefix(), ConsistentHashingNode.NodeTag.NORMAL)).collect(Collectors.toList());
            HoodieConsistentHashingMetadata newMeta = new HoodieConsistentHashingMetadata(meta.getVersion(), meta.getPartitionPath(), instantTime, meta.getNumBuckets(), seqNo + 1, newNodes);
            if (!ConsistentBucketIndexUtils.saveMetadata((HoodieTable)hoodieTable, (HoodieConsistentHashingMetadata)newMeta)) {
                throw new HoodieIndexException("Failed to save metadata for partition: " + partition);
            }
        });
        return writeStatuses;
    }
}

