/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.List;
import java.util.function.Supplier;
import org.apache.hudi.common.util.ValidationUtils;

public abstract class PartitionPathFormatterBase<S> {
    private final Supplier<StringBuilder<S>> stringBuilderFactory;
    private final boolean useHiveStylePartitioning;
    private final boolean useEncoding;

    PartitionPathFormatterBase(Supplier<StringBuilder<S>> stringBuilderFactory, boolean useHiveStylePartitioning, boolean useEncoding) {
        this.stringBuilderFactory = stringBuilderFactory;
        this.useHiveStylePartitioning = useHiveStylePartitioning;
        this.useEncoding = useEncoding;
    }

    public final S combine(List<String> partitionPathFields, Object ... partitionPathParts) {
        ValidationUtils.checkState((partitionPathParts.length == partitionPathFields.size() ? 1 : 0) != 0);
        if (!this.useHiveStylePartitioning && partitionPathParts.length == 1) {
            return this.tryEncode(this.handleEmpty(this.toString(partitionPathParts[0])));
        }
        StringBuilder<S> sb = this.stringBuilderFactory.get();
        for (int i = 0; i < partitionPathParts.length; ++i) {
            S partitionPathPartStr = this.tryEncode(this.handleEmpty(this.toString(partitionPathParts[i])));
            if (this.useHiveStylePartitioning) {
                sb.appendJava(partitionPathFields.get(i)).appendJava("=").append(partitionPathPartStr);
            } else {
                sb.append(partitionPathPartStr);
            }
            if (i >= partitionPathParts.length - 1) continue;
            sb.appendJava("/");
        }
        return sb.build();
    }

    private S tryEncode(S partitionPathPart) {
        return this.useEncoding ? this.encode(partitionPathPart) : partitionPathPart;
    }

    protected abstract S toString(Object var1);

    protected abstract S encode(S var1);

    protected abstract S handleEmpty(S var1);

    static interface StringBuilder<S> {
        default public StringBuilder<S> append(S s) {
            return this.appendJava(s.toString());
        }

        public StringBuilder<S> appendJava(String var1);

        public S build();
    }
}

