/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.util.function.Supplier;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.PartitionPathFormatterBase;
import org.apache.spark.unsafe.types.UTF8String;

public class UTF8StringPartitionPathFormatter
extends PartitionPathFormatterBase<UTF8String> {
    protected static final UTF8String HUDI_DEFAULT_PARTITION_PATH_UTF8 = UTF8String.fromString((String)"__HIVE_DEFAULT_PARTITION__");

    public UTF8StringPartitionPathFormatter(Supplier<PartitionPathFormatterBase.StringBuilder<UTF8String>> stringBuilderFactory, boolean useHiveStylePartitioning, boolean useEncoding) {
        super(stringBuilderFactory, useHiveStylePartitioning, useEncoding);
    }

    @Override
    protected UTF8String toString(Object o) {
        return BuiltinKeyGenerator.toUTF8String(o);
    }

    @Override
    protected UTF8String encode(UTF8String partitionPathPart) {
        return UTF8String.fromString((String)PartitionPathEncodeUtils.escapePathName((String)partitionPathPart.toString()));
    }

    @Override
    protected UTF8String handleEmpty(UTF8String partitionPathPart) {
        if (partitionPathPart == null || partitionPathPart.numChars() == 0) {
            return HUDI_DEFAULT_PARTITION_PATH_UTF8;
        }
        return partitionPathPart;
    }

    public static class UTF8StringBuilder
    implements PartitionPathFormatterBase.StringBuilder<UTF8String> {
        private final org.apache.hudi.unsafe.UTF8StringBuilder sb = new org.apache.hudi.unsafe.UTF8StringBuilder();

        @Override
        public PartitionPathFormatterBase.StringBuilder<UTF8String> appendJava(String s) {
            this.sb.append(s);
            return this;
        }

        @Override
        public PartitionPathFormatterBase.StringBuilder<UTF8String> append(UTF8String s) {
            this.sb.append(s);
            return this;
        }

        @Override
        public UTF8String build() {
            return this.sb.build();
        }
    }
}

