/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.client.utils.SparkMetadataWriterUtils;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.model.HoodieColumnRangeMetadata;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.HoodieJavaRDD;
import org.apache.hudi.index.HoodieSparkIndexClient;
import org.apache.hudi.index.expression.HoodieSparkExpressionIndex;
import org.apache.hudi.metadata.HoodieBackedTableMetadataWriter;
import org.apache.hudi.metadata.HoodieMetadataMetrics;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metadata.SparkHoodieMetadataBulkInsertPartitioner;
import org.apache.hudi.metrics.DistributedRegistry;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.spark.api.java.JavaRDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkHoodieBackedTableMetadataWriter
extends HoodieBackedTableMetadataWriter<JavaRDD<HoodieRecord>> {
    private static final Logger LOG = LoggerFactory.getLogger(SparkHoodieBackedTableMetadataWriter.class);

    public static HoodieTableMetadataWriter create(StorageConfiguration<?> conf, HoodieWriteConfig writeConfig, HoodieEngineContext context, Option<String> inflightInstantTimestamp) {
        return new SparkHoodieBackedTableMetadataWriter(conf, writeConfig, HoodieFailedWritesCleaningPolicy.EAGER, context, inflightInstantTimestamp);
    }

    public static HoodieTableMetadataWriter create(StorageConfiguration<?> conf, HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, HoodieEngineContext context, Option<String> inflightInstantTimestamp) {
        return new SparkHoodieBackedTableMetadataWriter(conf, writeConfig, failedWritesCleaningPolicy, context, inflightInstantTimestamp);
    }

    public static HoodieTableMetadataWriter create(StorageConfiguration<?> conf, HoodieWriteConfig writeConfig, HoodieEngineContext context) {
        return SparkHoodieBackedTableMetadataWriter.create(conf, writeConfig, context, (Option<String>)Option.empty());
    }

    SparkHoodieBackedTableMetadataWriter(StorageConfiguration<?> hadoopConf, HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, HoodieEngineContext engineContext, Option<String> inflightInstantTimestamp) {
        super(hadoopConf, writeConfig, failedWritesCleaningPolicy, engineContext, inflightInstantTimestamp);
    }

    protected void initRegistry() {
        if (this.metadataWriteConfig.isMetricsOn()) {
            if (this.metadataWriteConfig.isExecutorMetricsEnabled() && this.metadataWriteConfig.getMetricsReporterType() != MetricsReporterType.INMEMORY) {
                Registry registry = Registry.getRegistry((String)"HoodieMetadata", (String)DistributedRegistry.class.getName());
                HoodieSparkEngineContext sparkEngineContext = (HoodieSparkEngineContext)this.engineContext;
                ((DistributedRegistry)registry).register(sparkEngineContext.getJavaSparkContext());
            } else {
                Registry registry = Registry.getRegistry((String)"HoodieMetadata");
            }
            this.metrics = Option.of((Object)new HoodieMetadataMetrics(this.metadataWriteConfig.getMetricsConfig(), this.dataMetaClient.getStorage()));
        } else {
            this.metrics = Option.empty();
        }
    }

    protected void commit(String instantTime, Map<String, HoodieData<HoodieRecord>> partitionRecordsMap) {
        this.commitInternal(instantTime, partitionRecordsMap, false, Option.empty());
    }

    protected JavaRDD<HoodieRecord> convertHoodieDataToEngineSpecificData(HoodieData<HoodieRecord> records) {
        return HoodieJavaRDD.getJavaRDD(records);
    }

    protected void bulkCommit(String instantTime, String partitionName, HoodieData<HoodieRecord> records, int fileGroupCount) {
        SparkHoodieMetadataBulkInsertPartitioner partitioner = new SparkHoodieMetadataBulkInsertPartitioner(fileGroupCount);
        this.commitInternal(instantTime, Collections.singletonMap(partitionName, records), true, Option.of((Object)partitioner));
    }

    public void deletePartitions(String instantTime, List<MetadataPartitionType> partitions) {
        List<String> partitionsToDrop = partitions.stream().map(MetadataPartitionType::getPartitionPath).collect(Collectors.toList());
        LOG.info("Deleting Metadata Table partitions: {}", partitionsToDrop);
        SparkRDDWriteClient writeClient = (SparkRDDWriteClient)this.getWriteClient();
        String actionType = CommitUtils.getCommitActionType((WriteOperationType)WriteOperationType.DELETE_PARTITION, (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        writeClient.startCommitWithTime(instantTime, actionType);
        writeClient.deletePartitions(partitionsToDrop, instantTime);
    }

    protected HoodieData<HoodieRecord> getExpressionIndexUpdates(HoodieCommitMetadata commitMetadata, String indexPartition, String instantTime) throws Exception {
        HoodieIndexDefinition indexDefinition = this.getIndexDefinition(indexPartition);
        boolean isExprIndexUsingColumnStats = indexDefinition.getIndexType().equals("column_stats");
        Option partitionRecordsFunctionOpt = Option.empty();
        if (isExprIndexUsingColumnStats) {
            HoodiePairData exprIndexPartitionStatUpdates = SparkMetadataWriterUtils.getExpressionIndexPartitionStatUpdates(commitMetadata, indexPartition, this.engineContext, (HoodieTableMetadata)this.getTableMetadata(), this.dataMetaClient, this.dataWriteConfig.getMetadataConfig(), (Option<HoodieRecord.HoodieRecordType>)Option.of((Object)this.dataWriteConfig.getRecordMerger().getRecordType())).flatMapValues(List::iterator);
            partitionRecordsFunctionOpt = Option.of(rangeMetadata -> HoodieTableMetadataUtil.collectAndProcessExprIndexPartitionStatRecords((HoodiePairData)exprIndexPartitionStatUpdates.union(rangeMetadata), (boolean)true, (Option)Option.of((Object)indexDefinition.getIndexName())));
        }
        ArrayList<Pair<String, Pair<String, Long>>> partitionFilePathPairs = new ArrayList<Pair<String, Pair<String, Long>>>();
        commitMetadata.getPartitionToWriteStats().forEach((dataPartition, writeStats) -> writeStats.forEach(writeStat -> partitionFilePathPairs.add(Pair.of((Object)writeStat.getPartitionPath(), (Object)Pair.of((Object)new StoragePath(this.dataMetaClient.getBasePath(), writeStat.getPath()).toString(), (Object)writeStat.getFileSizeInBytes())))));
        int parallelism = Math.min(partitionFilePathPairs.size(), this.dataWriteConfig.getMetadataConfig().getExpressionIndexParallelism());
        Schema readerSchema = HoodieTableMetadataUtil.getProjectedSchemaForExpressionIndex((HoodieIndexDefinition)indexDefinition, (HoodieTableMetaClient)this.dataMetaClient);
        HoodieSparkExpressionIndex.ExpressionIndexComputationMetadata expressionIndexComputationMetadata = SparkMetadataWriterUtils.getExprIndexRecords(partitionFilePathPairs, indexDefinition, this.dataMetaClient, parallelism, readerSchema, instantTime, this.engineContext, this.dataWriteConfig, this.metadataWriteConfig, (Option<Function<HoodiePairData<String, HoodieColumnRangeMetadata<Comparable>>, HoodieData<HoodieRecord>>>)partitionRecordsFunctionOpt);
        return expressionIndexComputationMetadata.getPartitionStatRecordsOption().isPresent() ? expressionIndexComputationMetadata.getExpressionIndexRecords().union((HoodieData)expressionIndexComputationMetadata.getPartitionStatRecordsOption().get()) : expressionIndexComputationMetadata.getExpressionIndexRecords();
    }

    protected HoodieData<HoodieRecord> getExpressionIndexRecords(List<Pair<String, Pair<String, Long>>> partitionFilePathAndSizeTriplet, HoodieIndexDefinition indexDefinition, HoodieTableMetaClient metaClient, int parallelism, Schema readerSchema, StorageConfiguration<?> storageConf, String instantTime) {
        HoodieSparkExpressionIndex.ExpressionIndexComputationMetadata expressionIndexComputationMetadata = SparkMetadataWriterUtils.getExprIndexRecords(partitionFilePathAndSizeTriplet, indexDefinition, metaClient, parallelism, readerSchema, instantTime, this.engineContext, this.dataWriteConfig, this.metadataWriteConfig, (Option<Function<HoodiePairData<String, HoodieColumnRangeMetadata<Comparable>>, HoodieData<HoodieRecord>>>)Option.of(rangeMetadata -> HoodieTableMetadataUtil.collectAndProcessExprIndexPartitionStatRecords((HoodiePairData)rangeMetadata, (boolean)true, (Option)Option.of((Object)indexDefinition.getIndexName()))));
        HoodieData exprIndexRecords = expressionIndexComputationMetadata.getExpressionIndexRecords();
        if (indexDefinition.getIndexType().equals("column_stats")) {
            exprIndexRecords = exprIndexRecords.union((HoodieData)expressionIndexComputationMetadata.getPartitionStatRecordsOption().get());
        }
        return exprIndexRecords;
    }

    protected HoodieTable getTable(HoodieWriteConfig writeConfig, HoodieTableMetaClient metaClient) {
        return HoodieSparkTable.create(writeConfig, this.engineContext, metaClient);
    }

    public BaseHoodieWriteClient<?, JavaRDD<HoodieRecord>, ?, ?> initializeWriteClient() {
        return new SparkRDDWriteClient(this.engineContext, this.metadataWriteConfig, (Option<EmbeddedTimelineService>)Option.empty());
    }

    protected EngineType getEngineType() {
        return EngineType.SPARK;
    }

    protected void updateColumnsToIndexWithColStats(List<String> columnsToIndex) {
        new HoodieSparkIndexClient(this.dataWriteConfig, this.engineContext).createOrUpdateColumnStatsIndexDefinition(this.dataMetaClient, columnsToIndex);
    }
}

