/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.NumericUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.estimator.RecordSizeEstimator;
import org.apache.hudi.estimator.RecordSizeEstimatorFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.WorkloadProfile;
import org.apache.hudi.table.WorkloadStat;
import org.apache.hudi.table.action.commit.BucketInfo;
import org.apache.hudi.table.action.commit.BucketType;
import org.apache.hudi.table.action.commit.InsertBucket;
import org.apache.hudi.table.action.commit.InsertBucketCumulativeWeightPair;
import org.apache.hudi.table.action.commit.SmallFile;
import org.apache.hudi.table.action.commit.SparkHoodiePartitioner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class UpsertPartitioner<T>
extends SparkHoodiePartitioner<T> {
    private static final Logger LOG = LoggerFactory.getLogger(UpsertPartitioner.class);
    protected List<SmallFile> smallFiles = new ArrayList<SmallFile>();
    private int totalBuckets = 0;
    private final HashMap<String, Integer> updateLocationToBucket = new HashMap();
    private final HashMap<String, List<InsertBucketCumulativeWeightPair>> partitionPathToInsertBucketInfos = new HashMap();
    private final HashMap<Integer, BucketInfo> bucketInfoMap = new HashMap();
    protected final HoodieWriteConfig config;
    private final WriteOperationType operationType;
    private final RecordSizeEstimator recordSizeEstimator;

    public UpsertPartitioner(WorkloadProfile profile, HoodieEngineContext context, HoodieTable table, HoodieWriteConfig config, WriteOperationType operationType) {
        super(profile, table);
        this.config = config;
        this.operationType = operationType;
        this.recordSizeEstimator = RecordSizeEstimatorFactory.createRecordSizeEstimator((HoodieWriteConfig)config);
        this.assignUpdates(profile);
        long totalInserts = profile.getInputPartitionPathStatMap().values().stream().mapToLong(stat -> stat.getNumInserts()).sum();
        if (!WriteOperationType.isPreppedWriteOperation((WriteOperationType)operationType) || totalInserts > 0L) {
            this.assignInserts(profile, context);
        }
        LOG.info("Total Buckets: {}, bucketInfoMap size: {}, partitionPathToInsertBucketInfos size: {}, updateLocationToBucket size: {}", new Object[]{this.totalBuckets, this.bucketInfoMap.size(), this.partitionPathToInsertBucketInfos.size(), this.updateLocationToBucket.size()});
        if (LOG.isDebugEnabled()) {
            LOG.debug("Buckets info => " + this.bucketInfoMap + ", \nPartition to insert buckets => " + this.partitionPathToInsertBucketInfos + ", \nUpdateLocations mapped to buckets =>" + this.updateLocationToBucket);
        }
    }

    private void assignUpdates(WorkloadProfile profile) {
        Set partitionStatEntries = profile.getInputPartitionPathStatMap().entrySet();
        for (Map.Entry partitionStat : partitionStatEntries) {
            WorkloadStat outputWorkloadStats = profile.getOutputPartitionPathStatMap().getOrDefault(partitionStat.getKey(), new WorkloadStat());
            for (Map.Entry updateLocEntry : ((WorkloadStat)partitionStat.getValue()).getUpdateLocationToCount().entrySet()) {
                this.addUpdateBucket((String)partitionStat.getKey(), (String)updateLocEntry.getKey());
                if (!profile.hasOutputWorkLoadStats()) continue;
                HoodieRecordLocation hoodieRecordLocation = new HoodieRecordLocation((String)((Pair)updateLocEntry.getValue()).getKey(), (String)updateLocEntry.getKey());
                outputWorkloadStats.addUpdates(hoodieRecordLocation, ((Long)((Pair)updateLocEntry.getValue()).getValue()).longValue());
            }
            if (!profile.hasOutputWorkLoadStats()) continue;
            profile.updateOutputPartitionPathStatMap((String)partitionStat.getKey(), outputWorkloadStats);
        }
    }

    private int addUpdateBucket(String partitionPath, String fileIdHint) {
        int bucket = this.totalBuckets;
        this.updateLocationToBucket.put(fileIdHint, bucket);
        BucketInfo bucketInfo = new BucketInfo(BucketType.UPDATE, fileIdHint, partitionPath);
        this.bucketInfoMap.put(this.totalBuckets, bucketInfo);
        ++this.totalBuckets;
        return bucket;
    }

    private Map<String, Set<String>> getPartitionPathToPendingClusteringFileGroupsId() {
        Map<String, Set<String>> partitionPathToInPendingClusteringFileId = this.table.getFileSystemView().getFileGroupsInPendingClustering().map(fileGroupIdAndInstantPair -> Pair.of((Object)((HoodieFileGroupId)fileGroupIdAndInstantPair.getKey()).getPartitionPath(), (Object)((HoodieFileGroupId)fileGroupIdAndInstantPair.getKey()).getFileId())).collect(Collectors.groupingBy(Pair::getKey, Collectors.mapping(Pair::getValue, Collectors.toSet())));
        return partitionPathToInPendingClusteringFileId;
    }

    private List<SmallFile> filterSmallFilesInClustering(Set<String> pendingClusteringFileGroupsId, List<SmallFile> smallFiles) {
        if (!pendingClusteringFileGroupsId.isEmpty()) {
            return smallFiles.stream().filter(smallFile -> !pendingClusteringFileGroupsId.contains(smallFile.location.getFileId())).collect(Collectors.toList());
        }
        return smallFiles;
    }

    private void assignInserts(WorkloadProfile profile, HoodieEngineContext context) {
        Set partitionPaths = profile.getPartitionPaths();
        TimelineLayout layout = TimelineLayout.fromVersion((TimelineLayoutVersion)this.table.getActiveTimeline().getTimelineLayoutVersion());
        long averageRecordSize = this.recordSizeEstimator.averageBytesPerRecord(this.table.getMetaClient().getActiveTimeline().getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"commit", "deltacommit", "replacecommit"})).filterCompletedInstants(), layout.getCommitMetadataSerDe());
        LOG.info("AvgRecordSize => " + averageRecordSize);
        Map<String, List<SmallFile>> partitionSmallFilesMap = this.getSmallFilesForPartitions(new ArrayList<String>(partitionPaths), context);
        Map<String, Set<String>> partitionPathToPendingClusteringFileGroupsId = this.getPartitionPathToPendingClusteringFileGroupsId();
        for (String partitionPath : partitionPaths) {
            WorkloadStat pStat = profile.getWorkloadStat(partitionPath);
            WorkloadStat outputWorkloadStats = profile.getOutputPartitionPathStatMap().getOrDefault(partitionPath, new WorkloadStat());
            if (pStat.getNumInserts() > 0L) {
                List<SmallFile> smallFiles = this.filterSmallFilesInClustering(partitionPathToPendingClusteringFileGroupsId.getOrDefault(partitionPath, Collections.emptySet()), partitionSmallFilesMap.getOrDefault(partitionPath, Collections.emptyList()));
                this.smallFiles.addAll(smallFiles);
                LOG.info("For partitionPath : {} Total Small Files => {}", (Object)partitionPath, (Object)smallFiles.size());
                LOG.debug("For partitionPath : {} Small Files => {}", (Object)partitionPath, smallFiles);
                long totalUnassignedInserts = pStat.getNumInserts();
                ArrayList<Integer> bucketNumbers = new ArrayList<Integer>();
                ArrayList<Long> recordsPerBucket = new ArrayList<Long>();
                for (SmallFile smallFile : smallFiles) {
                    int bucket;
                    long recordsToAppend = Math.min((this.config.getParquetMaxFileSize() - smallFile.sizeBytes) / averageRecordSize, totalUnassignedInserts);
                    if (recordsToAppend <= 0L) continue;
                    if (this.updateLocationToBucket.containsKey(smallFile.location.getFileId())) {
                        bucket = this.updateLocationToBucket.get(smallFile.location.getFileId());
                        LOG.debug("Assigning " + recordsToAppend + " inserts to existing update bucket " + bucket);
                    } else {
                        bucket = this.addUpdateBucket(partitionPath, smallFile.location.getFileId());
                        LOG.debug("Assigning " + recordsToAppend + " inserts to new update bucket " + bucket);
                    }
                    if (profile.hasOutputWorkLoadStats()) {
                        outputWorkloadStats.addInserts(smallFile.location, recordsToAppend);
                    }
                    bucketNumbers.add(bucket);
                    recordsPerBucket.add(recordsToAppend);
                    if ((totalUnassignedInserts -= recordsToAppend) > 0L) continue;
                    break;
                }
                if (totalUnassignedInserts > 0L) {
                    long insertRecordsPerBucket = this.config.getCopyOnWriteInsertSplitSize();
                    if (this.config.shouldAutoTuneInsertSplits()) {
                        insertRecordsPerBucket = (int)Math.ceil(1.0 * (double)this.config.getParquetMaxFileSize() / (double)averageRecordSize);
                    }
                    int insertBuckets = (int)Math.ceil(1.0 * (double)totalUnassignedInserts / (double)insertRecordsPerBucket);
                    LOG.info("After small file assignment: unassignedInserts => " + totalUnassignedInserts + ", totalInsertBuckets => " + insertBuckets + ", recordsPerBucket => " + insertRecordsPerBucket);
                    for (int b = 0; b < insertBuckets; ++b) {
                        bucketNumbers.add(this.totalBuckets);
                        if (b < insertBuckets - 1) {
                            recordsPerBucket.add(insertRecordsPerBucket);
                        } else {
                            recordsPerBucket.add(totalUnassignedInserts - (long)(insertBuckets - 1) * insertRecordsPerBucket);
                        }
                        BucketInfo bucketInfo = new BucketInfo(BucketType.INSERT, FSUtils.createNewFileIdPfx(), partitionPath);
                        this.bucketInfoMap.put(this.totalBuckets, bucketInfo);
                        if (profile.hasOutputWorkLoadStats()) {
                            outputWorkloadStats.addInserts(new HoodieRecordLocation("null", bucketInfo.getFileIdPrefix()), ((Long)recordsPerBucket.get(recordsPerBucket.size() - 1)).longValue());
                        }
                        ++this.totalBuckets;
                    }
                }
                ArrayList<InsertBucketCumulativeWeightPair> insertBuckets = new ArrayList<InsertBucketCumulativeWeightPair>();
                double currentCumulativeWeight = 0.0;
                for (int i = 0; i < bucketNumbers.size(); ++i) {
                    InsertBucket bkt = new InsertBucket();
                    bkt.bucketNumber = (Integer)bucketNumbers.get(i);
                    bkt.weight = 1.0 * (double)((Long)recordsPerBucket.get(i)).longValue() / (double)pStat.getNumInserts();
                    insertBuckets.add(new InsertBucketCumulativeWeightPair(bkt, Double.valueOf(currentCumulativeWeight += bkt.weight)));
                }
                LOG.info("Total insert buckets for partition path " + partitionPath + " => " + insertBuckets);
                this.partitionPathToInsertBucketInfos.put(partitionPath, insertBuckets);
            }
            if (!profile.hasOutputWorkLoadStats()) continue;
            profile.updateOutputPartitionPathStatMap(partitionPath, outputWorkloadStats);
        }
    }

    private Map<String, List<SmallFile>> getSmallFilesForPartitions(List<String> partitionPaths, HoodieEngineContext context) {
        if (this.config.getParquetSmallFileLimit() <= 0 || partitionPaths == null || partitionPaths.isEmpty()) {
            return Collections.emptyMap();
        }
        if (this.table.getMetaClient().getCommitsTimeline().filterCompletedInstants().countInstants() == 0) {
            return Collections.emptyMap();
        }
        context.setJobStatus(((Object)((Object)this)).getClass().getSimpleName(), "Getting small files from partitions: " + this.config.getTableName());
        long startTimeMs = System.currentTimeMillis();
        Map partitionSmallFilesMap = context.mapToPair(partitionPaths, (SerializablePairFunction & Serializable)paritionPath -> Pair.of((Object)paritionPath, this.getSmallFiles((String)paritionPath)), Integer.valueOf(partitionPaths.size()));
        LOG.info("Fetched small files in {}ms", (Object)(System.currentTimeMillis() - startTimeMs));
        return partitionSmallFilesMap;
    }

    protected List<SmallFile> getSmallFiles(String partitionPath) {
        ArrayList<SmallFile> smallFileLocations = new ArrayList<SmallFile>();
        HoodieTimeline commitTimeline = this.table.getMetaClient().getCommitsTimeline().filterCompletedInstants();
        if (!commitTimeline.empty()) {
            HoodieInstant latestCommitTime = (HoodieInstant)commitTimeline.lastInstant().get();
            List allFiles = this.table.getBaseFileOnlyView().getLatestBaseFilesBeforeOrOn(partitionPath, latestCommitTime.requestedTime()).collect(Collectors.toList());
            for (HoodieBaseFile file : allFiles) {
                if (file.getFileSize() >= (long)this.config.getParquetSmallFileLimit()) continue;
                SmallFile sf = new SmallFile();
                sf.location = new HoodieRecordLocation(file.getCommitTime(), file.getFileId());
                sf.sizeBytes = file.getFileSize();
                smallFileLocations.add(sf);
            }
        }
        return smallFileLocations;
    }

    public List<BucketInfo> getBucketInfos() {
        return Collections.unmodifiableList(new ArrayList<BucketInfo>(this.bucketInfoMap.values()));
    }

    @Override
    public BucketInfo getBucketInfo(int bucketNumber) {
        return this.bucketInfoMap.get(bucketNumber);
    }

    public List<InsertBucketCumulativeWeightPair> getInsertBuckets(String partitionPath) {
        return this.partitionPathToInsertBucketInfos.get(partitionPath);
    }

    public int numPartitions() {
        return this.totalBuckets;
    }

    @Override
    public int getNumPartitions() {
        return this.totalBuckets;
    }

    public int getPartition(Object key) {
        Tuple2 keyLocation = (Tuple2)key;
        if (((Option)keyLocation._2()).isPresent()) {
            HoodieRecordLocation location = (HoodieRecordLocation)((Option)keyLocation._2()).get();
            return this.updateLocationToBucket.get(location.getFileId());
        }
        String partitionPath = ((HoodieKey)keyLocation._1()).getPartitionPath();
        List<InsertBucketCumulativeWeightPair> targetBuckets = this.partitionPathToInsertBucketInfos.get(partitionPath);
        long totalInserts = Math.max(1L, this.profile.getWorkloadStat(partitionPath).getNumInserts());
        long hashOfKey = NumericUtils.getMessageDigestHash((String)"MD5", (String)((HoodieKey)keyLocation._1()).getRecordKey());
        double r = 1.0 * (double)Math.floorMod(hashOfKey, totalInserts) / (double)totalInserts;
        int index = Collections.binarySearch(targetBuckets, new InsertBucketCumulativeWeightPair(new InsertBucket(), Double.valueOf(r)));
        if (index >= 0) {
            return ((InsertBucket)targetBuckets.get((int)index).getKey()).bucketNumber;
        }
        if (-1 * index - 1 < targetBuckets.size()) {
            return ((InsertBucket)targetBuckets.get((int)(-1 * index - 1)).getKey()).bucketNumber;
        }
        return ((InsertBucket)targetBuckets.get((int)0).getKey()).bucketNumber;
    }
}

