/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.internal;

import java.util.List;
import java.util.Random;
import org.apache.hudi.client.HoodieInternalWriteStatus;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.testutils.HoodieClientTestHarness;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;

public class HoodieBulkInsertInternalWriterTestBase
extends HoodieClientTestHarness {
    protected static final Random RANDOM = new Random();

    @BeforeEach
    public void setUp() throws Exception {
        this.initSparkContexts();
        this.initPath();
        this.initFileSystem();
        this.initTestDataGenerator();
        this.initMetaClient();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanupResources();
    }

    protected void assertWriteStatuses(List<HoodieInternalWriteStatus> writeStatuses, int batches, int size, Option<List<String>> fileAbsPaths, Option<List<String>> fileNames) {
        Assertions.assertEquals((int)batches, (int)writeStatuses.size());
        int counter = 0;
        for (HoodieInternalWriteStatus writeStatus : writeStatuses) {
            Assertions.assertEquals((Object)HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS[counter % 3], (Object)writeStatus.getPartitionPath());
            Assertions.assertEquals((long)writeStatus.getTotalRecords(), (long)size);
            Assertions.assertNull((Object)writeStatus.getGlobalError());
            Assertions.assertEquals((long)writeStatus.getFailedRowsSize(), (long)0L);
            Assertions.assertEquals((long)writeStatus.getTotalErrorRecords(), (long)0L);
            Assertions.assertFalse((boolean)writeStatus.hasErrors());
            Assertions.assertNotNull((Object)writeStatus.getFileId());
            String fileId = writeStatus.getFileId();
            if (fileAbsPaths.isPresent()) {
                ((List)fileAbsPaths.get()).add(this.basePath + "/" + writeStatus.getStat().getPath());
            }
            if (fileNames.isPresent()) {
                ((List)fileNames.get()).add(writeStatus.getStat().getPath().substring(writeStatus.getStat().getPath().lastIndexOf(47) + 1));
            }
            HoodieWriteStat writeStat = writeStatus.getStat();
            Assertions.assertEquals((long)size, (long)writeStat.getNumInserts());
            Assertions.assertEquals((long)size, (long)writeStat.getNumWrites());
            Assertions.assertEquals((Object)fileId, (Object)writeStat.getFileId());
            Assertions.assertEquals((Object)HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS[counter++ % 3], (Object)writeStat.getPartitionPath());
            Assertions.assertEquals((long)0L, (long)writeStat.getNumDeletes());
            Assertions.assertEquals((long)0L, (long)writeStat.getNumUpdateWrites());
            Assertions.assertEquals((long)0L, (long)writeStat.getTotalWriteErrors());
        }
    }

    protected void assertOutput(Dataset<Row> expectedRows, Dataset<Row> actualRows, String instantTime, Option<List<String>> fileNames) {
        actualRows.collectAsList().forEach(entry -> {
            Assertions.assertEquals((Object)entry.get(((Integer)HoodieRecord.HOODIE_META_COLUMNS_NAME_TO_POS.get("_hoodie_commit_time")).intValue()).toString(), (Object)instantTime);
            Assertions.assertFalse((boolean)entry.isNullAt(((Integer)HoodieRecord.HOODIE_META_COLUMNS_NAME_TO_POS.get("_hoodie_file_name")).intValue()));
            if (fileNames.isPresent()) {
                Assertions.assertTrue((boolean)((List)fileNames.get()).contains(entry.get(((Integer)HoodieRecord.HOODIE_META_COLUMNS_NAME_TO_POS.get("_hoodie_file_name")).intValue())));
            }
            Assertions.assertFalse((boolean)entry.isNullAt(((Integer)HoodieRecord.HOODIE_META_COLUMNS_NAME_TO_POS.get("_hoodie_commit_seqno")).intValue()));
        });
        Dataset trimmedExpected = expectedRows.drop(new String[]{"_hoodie_commit_seqno", "_hoodie_commit_time", "_hoodie_file_name"});
        Dataset trimmedActual = actualRows.drop(new String[]{"_hoodie_commit_seqno", "_hoodie_commit_time", "_hoodie_file_name"});
        Assertions.assertEquals((long)0L, (long)trimmedActual.except(trimmedExpected).count());
    }
}

