/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobID;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.TaskID;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.mapreduce.task.TaskAttemptContextImpl;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetRecordReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.TaskContext$;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.JoinedRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.codegen.GenerateUnsafeProjection$;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.execution.datasources.RecordReaderIterator;
import org.apache.spark.sql.execution.datasources.parquet.HoodieParquetFileFormatHelper$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFilters;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.Spark24HoodieVectorizedParquetRecordReader;
import org.apache.spark.sql.execution.datasources.parquet.VectorizedParquetRecordReader;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.util.SerializableConfiguration;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0002\u0004\u0001+!A!\u0004\u0001BC\u0002\u0013%1\u0004\u0003\u0005#\u0001\t\u0005\t\u0015!\u0003\u001d\u0011\u0015\u0019\u0003\u0001\"\u0001%\u0011\u00159\u0003\u0001\"\u0011)\u0005y\u0019\u0006/\u0019:leQBun\u001c3jKB\u000b'/];fi\u001aKG.\u001a$pe6\fGO\u0003\u0002\b\u0011\u00059\u0001/\u0019:rk\u0016$(BA\u0005\u000b\u0003-!\u0017\r^1t_V\u00148-Z:\u000b\u0005-a\u0011!C3yK\u000e,H/[8o\u0015\tia\"A\u0002tc2T!a\u0004\t\u0002\u000bM\u0004\u0018M]6\u000b\u0005E\u0011\u0012AB1qC\u000eDWMC\u0001\u0014\u0003\ry'oZ\u0002\u0001'\t\u0001a\u0003\u0005\u0002\u001815\ta!\u0003\u0002\u001a\r\t\t\u0002+\u0019:rk\u0016$h)\u001b7f\r>\u0014X.\u0019;\u00027MDw.\u001e7e\u0003B\u0004XM\u001c3QCJ$\u0018\u000e^5p]Z\u000bG.^3t+\u0005a\u0002CA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"a\u0002\"p_2,\u0017M\\\u0001\u001dg\"|W\u000f\u001c3BaB,g\u000e\u001a)beRLG/[8o-\u0006dW/Z:!\u0003\u0019a\u0014N\\5u}Q\u0011QE\n\t\u0003/\u0001AQAG\u0002A\u0002q\taDY;jY\u0012\u0014V-\u00193fe^KG\u000f\u001b)beRLG/[8o-\u0006dW/Z:\u0015\u0011%\u0012\u0005\n\u0015*U?2\u0004B!\b\u0016-a%\u00111F\b\u0002\n\rVt7\r^5p]F\u0002\"!\f\u0018\u000e\u0003!I!a\f\u0005\u0003\u001fA\u000b'\u000f^5uS>tW\r\u001a$jY\u0016\u00042!M\u001d=\u001d\t\u0011tG\u0004\u00024m5\tAG\u0003\u00026)\u00051AH]8pizJ\u0011aH\u0005\u0003qy\tq\u0001]1dW\u0006<W-\u0003\u0002;w\tA\u0011\n^3sCR|'O\u0003\u00029=A\u0011Q\bQ\u0007\u0002})\u0011q\bD\u0001\tG\u0006$\u0018\r\\=ti&\u0011\u0011I\u0010\u0002\f\u0013:$XM\u001d8bYJ{w\u000fC\u0003D\t\u0001\u0007A)\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002F\r6\tA\"\u0003\u0002H\u0019\ta1\u000b]1sWN+7o]5p]\")\u0011\n\u0002a\u0001\u0015\u0006QA-\u0019;b'\u000eDW-\\1\u0011\u0005-sU\"\u0001'\u000b\u00055c\u0011!\u0002;za\u0016\u001c\u0018BA(M\u0005)\u0019FO];diRK\b/\u001a\u0005\u0006#\u0012\u0001\rAS\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001c6\r[3nC\")1\u000b\u0002a\u0001\u0015\u0006q!/Z9vSJ,GmU2iK6\f\u0007\"B+\u0005\u0001\u00041\u0016a\u00024jYR,'o\u001d\t\u0004c]K\u0016B\u0001-<\u0005\r\u0019V-\u001d\t\u00035vk\u0011a\u0017\u0006\u000392\tqa]8ve\u000e,7/\u0003\u0002_7\n1a)\u001b7uKJDQ\u0001\u0019\u0003A\u0002\u0005\fqa\u001c9uS>t7\u000f\u0005\u0003cM&LgBA2e!\t\u0019d$\u0003\u0002f=\u00051\u0001K]3eK\u001aL!a\u001a5\u0003\u00075\u000b\u0007O\u0003\u0002f=A\u0011!M[\u0005\u0003W\"\u0014aa\u0015;sS:<\u0007\"B7\u0005\u0001\u0004q\u0017A\u00035bI>|\u0007oQ8oMB\u0011q\u000e^\u0007\u0002a*\u0011\u0011O]\u0001\u0005G>tgM\u0003\u0002t!\u00051\u0001.\u00193p_BL!!\u001e9\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0001")
public class Spark24HoodieParquetFileFormat
extends ParquetFileFormat {
    private final boolean shouldAppendPartitionValues;

    private boolean shouldAppendPartitionValues() {
        return this.shouldAppendPartitionValues;
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> buildReaderWithPartitionValues(SparkSession sparkSession, StructType dataSchema, StructType partitionSchema, StructType requiredSchema, Seq<Filter> filters, scala.collection.immutable.Map<String, String> options, Configuration hadoopConf) {
        hadoopConf.set("parquet.read.support.class", ParquetReadSupport.class.getName());
        hadoopConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), requiredSchema.json());
        hadoopConf.set(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA(), requiredSchema.json());
        hadoopConf.set(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key(), sparkSession.sessionState().conf().sessionLocalTimeZone());
        hadoopConf.setBoolean(SQLConf$.MODULE$.CASE_SENSITIVE().key(), sparkSession.sessionState().conf().caseSensitiveAnalysis());
        ParquetWriteSupport$.MODULE$.setSchema(requiredSchema, hadoopConf);
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_BINARY_AS_STRING().key(), sparkSession.sessionState().conf().isParquetBinaryAsString());
        hadoopConf.setBoolean(SQLConf$.MODULE$.PARQUET_INT96_AS_TIMESTAMP().key(), sparkSession.sessionState().conf().isParquetINT96AsTimestamp());
        Broadcast broadcastedHadoopConf = sparkSession.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        StructType resultSchema = new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionSchema.fields())).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class))));
        SQLConf sqlConf = sparkSession.sessionState().conf();
        boolean enableOffHeapColumnVector = sqlConf.offHeapColumnVectorEnabled();
        boolean enableVectorizedReader = sqlConf.parquetVectorizedReaderEnabled() && resultSchema.forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Spark24HoodieParquetFileFormat.$anonfun$buildReaderWithPartitionValues$1(x$1)));
        boolean enableRecordFilter = sqlConf.parquetRecordFilterEnabled();
        boolean timestampConversion = sqlConf.isParquetINT96TimestampConversion();
        int capacity = sqlConf.parquetVectorizedReaderBatchSize();
        boolean enableParquetFilterPushDown = sqlConf.parquetFilterPushDown();
        boolean returningBatch = this.supportBatch(sparkSession, resultSchema);
        boolean pushDownDate = sqlConf.parquetFilterPushDownDate();
        boolean pushDownTimestamp = sqlConf.parquetFilterPushDownTimestamp();
        boolean pushDownDecimal = sqlConf.parquetFilterPushDownDecimal();
        boolean pushDownStringStartWith = sqlConf.parquetFilterPushDownStringStartWith();
        int pushDownInFilterThreshold = sqlConf.parquetFilterPushDownInFilterThreshold();
        boolean isCaseSensitive = sqlConf.caseSensitiveAnalysis();
        return (Function1 & Serializable & scala.Serializable)file -> {
            RecordReaderIterator recordReaderIterator;
            None$ none$;
            LazyRef footerFileMetaData$lzy = new LazyRef();
            Predef$.MODULE$.assert(!this.shouldAppendPartitionValues() || file.partitionValues().numFields() == partitionSchema.size());
            FileSplit fileSplit = new FileSplit(new Path(new URI(file.filePath())), file.start(), file.length(), (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)));
            Path filePath = fileSplit.getPath();
            ParquetInputSplit split = new ParquetInputSplit(filePath, fileSplit.getStart(), fileSplit.getStart() + fileSplit.getLength(), fileSplit.getLength(), fileSplit.getLocations(), null);
            Configuration sharedConf = ((SerializableConfiguration)broadcastedHadoopConf.value()).value();
            if (enableParquetFilterPushDown) {
                MessageType parquetSchema = Spark24HoodieParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath).getSchema();
                ParquetFilters parquetFilters = new ParquetFilters(pushDownDate, pushDownTimestamp, pushDownDecimal, pushDownStringStartWith, pushDownInFilterThreshold, isCaseSensitive);
                none$ = ((TraversableOnce)filters.flatMap((Function1 & Serializable & scala.Serializable)x$2 -> Option$.MODULE$.option2Iterable(parquetFilters.createFilter(parquetSchema, x$2)), Seq$.MODULE$.canBuildFrom())).reduceOption((Function2 & Serializable & scala.Serializable)(x$1, x$2) -> FilterApi.and((FilterPredicate)x$1, (FilterPredicate)x$2));
            } else {
                none$ = None$.MODULE$;
            }
            None$ pushed = none$;
            None$ convertTz = timestampConversion && !Spark24HoodieParquetFileFormat.isCreatedByParquetMr$1(footerFileMetaData$lzy, sharedConf, filePath) ? new Some((Object)DateTimeUtils$.MODULE$.getTimeZone(sharedConf.get(SQLConf$.MODULE$.SESSION_LOCAL_TIMEZONE().key()))) : None$.MODULE$;
            TaskAttemptID attemptId = new TaskAttemptID(new TaskID(new JobID(), TaskType.MAP, 0), 0);
            Configuration hadoopAttemptConf = new Configuration(((SerializableConfiguration)broadcastedHadoopConf.value()).value());
            Tuple2 tuple2 = HoodieParquetFileFormatHelper$.MODULE$.buildImplicitSchemaChangeInfo(hadoopAttemptConf, Spark24HoodieParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy, sharedConf, filePath), requiredSchema);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Map implicitTypeChangeInfos = (Map)tuple2._1();
            StructType sparkRequestSchema = (StructType)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)implicitTypeChangeInfos, (Object)sparkRequestSchema);
            Tuple2 tuple23 = tuple22;
            Map implicitTypeChangeInfos2 = (Map)tuple23._1();
            StructType sparkRequestSchema2 = (StructType)tuple23._2();
            if (!implicitTypeChangeInfos2.isEmpty()) {
                hadoopAttemptConf.set(ParquetReadSupport$.MODULE$.SPARK_ROW_REQUESTED_SCHEMA(), sparkRequestSchema2.json());
            }
            TaskAttemptContextImpl hadoopAttemptContext = new TaskAttemptContextImpl(hadoopAttemptConf, attemptId);
            if (pushed.isDefined()) {
                ParquetInputFormat.setFilterPredicate((Configuration)hadoopAttemptContext.getConfiguration(), (FilterPredicate)((FilterPredicate)pushed.get()));
            }
            Option taskContext = Option$.MODULE$.apply((Object)TaskContext$.MODULE$.get());
            if (enableVectorizedReader) {
                Spark24HoodieVectorizedParquetRecordReader vectorizedReader = !implicitTypeChangeInfos2.isEmpty() ? new Spark24HoodieVectorizedParquetRecordReader((TimeZone)convertTz.orNull(Predef$.MODULE$.$conforms()), enableOffHeapColumnVector && taskContext.isDefined(), capacity, implicitTypeChangeInfos2) : new VectorizedParquetRecordReader((TimeZone)convertTz.orNull(Predef$.MODULE$.$conforms()), enableOffHeapColumnVector && taskContext.isDefined(), capacity);
                RecordReaderIterator iter = new RecordReaderIterator((RecordReader)vectorizedReader);
                taskContext.foreach((Function1 & Serializable & scala.Serializable)x$4 -> x$4.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$5 -> {
                    iter.close();
                    return BoxedUnit.UNIT;
                }));
                vectorizedReader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                if (this.shouldAppendPartitionValues()) {
                    this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(11).append("Appending ").append(partitionSchema).append(" ").append(file.partitionValues()).toString());
                    vectorizedReader.initBatch(partitionSchema, file.partitionValues());
                } else {
                    vectorizedReader.initBatch(StructType$.MODULE$.apply((Seq)Nil$.MODULE$), InternalRow$.MODULE$.empty());
                }
                if (returningBatch) {
                    vectorizedReader.enableReturningBatches();
                }
                recordReaderIterator = iter;
            } else {
                UnsafeProjection unsafeProjection;
                UnsafeProjection unsafeProjection2;
                ParquetRecordReader parquetRecordReader;
                this.logDebug((Function0 & Serializable & scala.Serializable)() -> "Falling back to parquet-mr");
                ParquetReadSupport readSupport = new ParquetReadSupport((Option)convertTz);
                if (pushed.isDefined() && enableRecordFilter) {
                    FilterCompat.Filter parquetFilter = FilterCompat.get((FilterPredicate)((FilterPredicate)pushed.get()), null);
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport, parquetFilter);
                } else {
                    parquetRecordReader = new ParquetRecordReader((ReadSupport)readSupport);
                }
                ParquetRecordReader reader = parquetRecordReader;
                RecordReaderIterator iter = new RecordReaderIterator((RecordReader)reader);
                taskContext.foreach((Function1 & Serializable & scala.Serializable)x$6 -> x$6.addTaskCompletionListener((Function1 & Serializable & scala.Serializable)x$7 -> {
                    iter.close();
                    return BoxedUnit.UNIT;
                }));
                reader.initialize((InputSplit)split, (TaskAttemptContext)hadoopAttemptContext);
                Seq fullSchema = (Seq)requiredSchema.toAttributes().$plus$plus((GenTraversableOnce)partitionSchema.toAttributes(), Seq$.MODULE$.canBuildFrom());
                if (implicitTypeChangeInfos2.isEmpty()) {
                    unsafeProjection2 = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)fullSchema, fullSchema);
                } else {
                    Seq newFullSchema = (Seq)new StructType((StructField[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                        Tuple2 tuple2 = x0$1;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        StructField f = (StructField)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        StructField structField = implicitTypeChangeInfos2.containsKey(BoxesRunTime.boxToInteger((int)i)) ? new StructField(f.name(), (DataType)((Pair)implicitTypeChangeInfos2.get(BoxesRunTime.boxToInteger((int)i))).getRight(), f.nullable(), f.metadata()) : f;
                        return structField;
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(StructField.class)))).toAttributes().$plus$plus((GenTraversableOnce)partitionSchema.toAttributes(), Seq$.MODULE$.canBuildFrom());
                    Seq castSchema = (Seq)((TraversableLike)newFullSchema.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        AttributeReference attr = (AttributeReference)tuple2._1();
                        int i = tuple2._2$mcI$sp();
                        AttributeReference attributeReference = implicitTypeChangeInfos2.containsKey(BoxesRunTime.boxToInteger((int)i)) ? new Cast((Expression)attr, (DataType)((Pair)implicitTypeChangeInfos2.get(BoxesRunTime.boxToInteger((int)i))).getLeft(), Cast$.MODULE$.apply$default$3()) : attr;
                        return attributeReference;
                    }, Seq$.MODULE$.canBuildFrom());
                    unsafeProjection2 = unsafeProjection = (UnsafeProjection)GenerateUnsafeProjection$.MODULE$.generate((Object)castSchema, newFullSchema);
                }
                if (!this.shouldAppendPartitionValues() || partitionSchema.length() == 0) {
                    recordReaderIterator = iter.map((Function1)unsafeProjection);
                } else {
                    JoinedRow joinedRow = new JoinedRow();
                    recordReaderIterator = iter.map((Function1 & Serializable & scala.Serializable)d -> unsafeProjection.apply((InternalRow)joinedRow.apply(d, file.partitionValues())));
                }
            }
            return recordReaderIterator;
        };
    }

    public static final /* synthetic */ boolean $anonfun$buildReaderWithPartitionValues$1(StructField x$1) {
        return x$1.dataType() instanceof AtomicType;
    }

    private static final /* synthetic */ FileMetaData footerFileMetaData$lzycompute$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        FileMetaData fileMetaData;
        LazyRef lazyRef = footerFileMetaData$lzy$1;
        synchronized (lazyRef) {
            fileMetaData = footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : (FileMetaData)footerFileMetaData$lzy$1.initialize((Object)ParquetFileReader.readFooter((Configuration)sharedConf$1, (Path)filePath$1, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.SKIP_ROW_GROUPS).getFileMetaData());
        }
        return fileMetaData;
    }

    private static final FileMetaData footerFileMetaData$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        return footerFileMetaData$lzy$1.initialized() ? (FileMetaData)footerFileMetaData$lzy$1.value() : Spark24HoodieParquetFileFormat.footerFileMetaData$lzycompute$1(footerFileMetaData$lzy$1, sharedConf$1, filePath$1);
    }

    private static final boolean isCreatedByParquetMr$1(LazyRef footerFileMetaData$lzy$1, Configuration sharedConf$1, Path filePath$1) {
        return Spark24HoodieParquetFileFormat.footerFileMetaData$1(footerFileMetaData$lzy$1, sharedConf$1, filePath$1).getCreatedBy().startsWith("parquet-mr");
    }

    public Spark24HoodieParquetFileFormat(boolean shouldAppendPartitionValues) {
        this.shouldAppendPartitionValues = shouldAppendPartitionValues;
    }
}

