/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core.util;

import io.javalin.InternalServerErrorResponse;
import io.javalin.core.util.OptionalDependency;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0005H\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0005J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0005J\u0012\u0010\u0017\u001a\u00020\u00062\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019J\u0006\u0010\u001a\u001a\u00020\u0005J\u0015\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u001cJ\u000e\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005J\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00050 2\u0006\u0010!\u001a\u00020\u0005J\u0018\u0010\"\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0005H\u0007J\u0006\u0010#\u001a\u00020\rR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lio/javalin/core/util/Util;", "", "()V", "dependencyCheckCache", "Ljava/util/HashMap;", "", "", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "classExists", "className", "ensureDependencyPresent", "", "dependency", "Lio/javalin/core/util/OptionalDependency;", "getChecksumAndReset", "inputStream", "Ljava/io/InputStream;", "getFileUrl", "Ljava/net/URL;", "path", "getResourceUrl", "isKotlinClass", "clazz", "Ljava/lang/Class;", "javalinBanner", "missingDependencyMessage", "missingDependencyMessage$javalin", "normalizeContextPath", "contextPath", "pathToList", "", "pathString", "prefixContextPath", "printHelpfulMessageIfLoggerIsMissing", "javalin"})
public final class Util {
    private static final Logger log;
    private static final HashMap<String, Boolean> dependencyCheckCache;
    public static final Util INSTANCE;

    @NotNull
    public final String normalizeContextPath(@NotNull String contextPath) {
        Intrinsics.checkParameterIsNotNull(contextPath, "contextPath");
        CharSequence charSequence = '/' + contextPath;
        Object object = "/{2,}";
        object = new Regex((String)object);
        String string = "/";
        return StringsKt.removeSuffix(((Regex)object).replace(charSequence, string), (CharSequence)"/");
    }

    @JvmStatic
    @NotNull
    public static final String prefixContextPath(@NotNull String contextPath, @NotNull String path) {
        String string;
        Intrinsics.checkParameterIsNotNull(contextPath, "contextPath");
        Intrinsics.checkParameterIsNotNull(path, "path");
        if (Intrinsics.areEqual(path, "*")) {
            string = path;
        } else {
            CharSequence charSequence = contextPath + '/' + path;
            Object object = "/{2,}";
            object = new Regex((String)object);
            String string2 = "/";
            string = ((Regex)object).replace(charSequence, string2);
        }
        return string;
    }

    private final boolean classExists(String className) {
        boolean bl;
        try {
            Class.forName(className);
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }

    public final void ensureDependencyPresent(@NotNull OptionalDependency dependency) {
        Intrinsics.checkParameterIsNotNull((Object)dependency, "dependency");
        if (Intrinsics.areEqual(dependencyCheckCache.get(dependency.getTestClass()), true)) {
            return;
        }
        if (!this.classExists(dependency.getTestClass())) {
            String message = this.missingDependencyMessage$javalin(dependency);
            log.warn(message);
            throw (Throwable)new InternalServerErrorResponse(message);
        }
        Map map = dependencyCheckCache;
        String string = dependency.getTestClass();
        Boolean bl = true;
        map.put(string, bl);
    }

    @NotNull
    public final String missingDependencyMessage$javalin(@NotNull OptionalDependency dependency) {
        Intrinsics.checkParameterIsNotNull((Object)dependency, "dependency");
        return StringsKt.trimMargin$default("\n            |Missing dependency '" + dependency.getDisplayName() + "'. Add the dependency.\n            |\n            |pom.xml:\n            |<dependency>\n            |    <groupId>" + dependency.getGroupId() + "</groupId>\n            |    <artifactId>" + dependency.getArtifactId() + "</artifactId>\n            |    <version>" + dependency.getVersion() + "</version>\n            |</dependency>\n            |\n            |build.gradle:\n            |compile \"" + dependency.getGroupId() + ':' + dependency.getArtifactId() + ':' + dependency.getVersion() + '\"', null, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> pathToList(@NotNull String pathString) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(pathString, "pathString");
        Iterable iterable = $receiver$iv = (Iterable)StringsKt.split$default((CharSequence)pathString, new String[]{"/"}, false, 0, 6, null);
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            String it = (String)element$iv$iv;
            CharSequence charSequence = it;
            if (!(charSequence.length() > 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final void printHelpfulMessageIfLoggerIsMissing() {
        if (!this.classExists(OptionalDependency.SLF4JSIMPLE.getTestClass())) {
            System.err.println(StringsKt.trimMargin$default("\n            |-------------------------------------------------------------------\n            |" + this.missingDependencyMessage$javalin(OptionalDependency.SLF4JSIMPLE) + "\n            |-------------------------------------------------------------------\n            |Visit https://javalin.io/documentation#logging if you need more help", null, 1, null));
        }
    }

    @NotNull
    public final String javalinBanner() {
        return "\n" + StringsKt.trimMargin$default("\n          |           __                      __ _\n          |          / /____ _ _   __ ____ _ / /(_)____\n          |     __  / // __ `/| | / // __ `// // // __ \\\n          |    / /_/ // /_/ / | |/ // /_/ // // // / / /\n          |    \\____/ \\__,_/  |___/ \\__,_//_//_//_/ /_/\n          |\n          |        https://javalin.io/documentation\n          |", null, 1, null);
    }

    @NotNull
    public final String getChecksumAndReset(@NotNull InputStream inputStream) {
        Intrinsics.checkParameterIsNotNull(inputStream, "inputStream");
        CheckedInputStream cis = new CheckedInputStream(inputStream, new Adler32());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteStreamsKt.copyTo$default(cis, out, 0, 2, null);
        inputStream.reset();
        Checksum checksum = cis.getChecksum();
        Intrinsics.checkExpressionValueIsNotNull(checksum, "cis.checksum");
        return String.valueOf(checksum.getValue());
    }

    @Nullable
    public final URL getResourceUrl(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return this.getClass().getClassLoader().getResource(path);
    }

    @Nullable
    public final URL getFileUrl(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull(path, "path");
        return new File(path).exists() ? new File(path).toURI().toURL() : null;
    }

    public final boolean isKotlinClass(@NotNull Class<?> clazz) {
        Intrinsics.checkParameterIsNotNull(clazz, "clazz");
        try {
            for (Annotation annotation : clazz.getDeclaredAnnotations()) {
                if (!StringsKt.contains$default((CharSequence)JvmClassMappingKt.getAnnotationClass(annotation).toString(), "kotlin.Metadata", false, 2, null)) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private Util() {
    }

    static {
        Util util;
        INSTANCE = util = new Util();
        log = LoggerFactory.getLogger(Util.class);
        dependencyCheckCache = new HashMap();
    }
}

