/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hudi.spark.com.google.common.collect.Sets;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZKNamespaceManager
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(ZKNamespaceManager.class);
    private final String nsZNode = ZooKeeperWatcher.namespaceZNode;
    private volatile NavigableMap<String, NamespaceDescriptor> cache = new ConcurrentSkipListMap<String, NamespaceDescriptor>();

    public ZKNamespaceManager(ZooKeeperWatcher zkw) throws IOException {
        super(zkw);
    }

    public void start() throws IOException {
        this.watcher.registerListener(this);
        try {
            if (ZKUtil.watchAndCheckExists(this.watcher, this.nsZNode)) {
                List<ZKUtil.NodeAndData> existing = ZKUtil.getChildDataAndWatchForNewChildren(this.watcher, this.nsZNode);
                if (existing != null) {
                    this.refreshNodes(existing);
                }
            } else {
                ZKUtil.createWithParents(this.watcher, this.nsZNode);
            }
        }
        catch (KeeperException e) {
            throw new IOException("Failed to initialize ZKNamespaceManager", e);
        }
    }

    public NamespaceDescriptor get(String name) {
        return (NamespaceDescriptor)this.cache.get(name);
    }

    public void update(NamespaceDescriptor ns) throws IOException {
        this.writeNamespace(ns);
        this.cache.put(ns.getName(), ns);
    }

    public void remove(String name) throws IOException {
        this.deleteNamespace(name);
        this.cache.remove(name);
    }

    public NavigableSet<NamespaceDescriptor> list() throws IOException {
        TreeSet<NamespaceDescriptor> ret = Sets.newTreeSet(NamespaceDescriptor.NAMESPACE_DESCRIPTOR_COMPARATOR);
        for (NamespaceDescriptor ns : this.cache.values()) {
            ret.add(ns);
        }
        return ret;
    }

    @Override
    public void nodeCreated(String path) {
        if (this.nsZNode.equals(path)) {
            try {
                List<ZKUtil.NodeAndData> nodes = ZKUtil.getChildDataAndWatchForNewChildren(this.watcher, this.nsZNode);
                this.refreshNodes(nodes);
            }
            catch (KeeperException ke) {
                String msg = "Error reading data from zookeeper";
                LOG.error((Object)msg, (Throwable)ke);
                this.watcher.abort(msg, ke);
            }
            catch (IOException e) {
                String msg = "Error parsing data from zookeeper";
                LOG.error((Object)msg, (Throwable)e);
                this.watcher.abort(msg, e);
            }
        }
    }

    @Override
    public void nodeDeleted(String path) {
        if (this.nsZNode.equals(ZKUtil.getParent(path))) {
            String nsName = ZKUtil.getNodeName(path);
            this.cache.remove(nsName);
        }
    }

    @Override
    public void nodeDataChanged(String path) {
        if (this.nsZNode.equals(ZKUtil.getParent(path))) {
            try {
                byte[] data = ZKUtil.getDataAndWatch(this.watcher, path);
                NamespaceDescriptor ns = ProtobufUtil.toNamespaceDescriptor(HBaseProtos.NamespaceDescriptor.parseFrom(data));
                this.cache.put(ns.getName(), ns);
            }
            catch (KeeperException ke) {
                String msg = "Error reading data from zookeeper for node " + path;
                LOG.error((Object)msg, (Throwable)ke);
                this.watcher.abort(msg, ke);
            }
            catch (IOException ioe) {
                String msg = "Error deserializing namespace: " + path;
                LOG.error((Object)msg, (Throwable)ioe);
                this.watcher.abort(msg, ioe);
            }
        }
    }

    @Override
    public void nodeChildrenChanged(String path) {
        if (this.nsZNode.equals(path)) {
            try {
                List<ZKUtil.NodeAndData> nodes = ZKUtil.getChildDataAndWatchForNewChildren(this.watcher, this.nsZNode);
                this.refreshNodes(nodes);
            }
            catch (KeeperException ke) {
                LOG.error((Object)("Error reading data from zookeeper for path " + path), (Throwable)ke);
                this.watcher.abort("Zookeeper error get node children for path " + path, ke);
            }
            catch (IOException e) {
                LOG.error((Object)("Error deserializing namespace child from: " + path), (Throwable)e);
                this.watcher.abort("Error deserializing namespace child from: " + path, e);
            }
        }
    }

    private void deleteNamespace(String name) throws IOException {
        String zNode = ZKUtil.joinZNode(this.nsZNode, name);
        try {
            ZKUtil.deleteNode(this.watcher, zNode);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Failed updating permissions for namespace " + name), (Throwable)e);
            throw new IOException("Failed updating permissions for namespace " + name, e);
        }
    }

    private void writeNamespace(NamespaceDescriptor ns) throws IOException {
        String zNode = ZKUtil.joinZNode(this.nsZNode, ns.getName());
        try {
            ZKUtil.createWithParents(this.watcher, zNode);
            ZKUtil.updateExistingNodeData(this.watcher, zNode, ProtobufUtil.toProtoNamespaceDescriptor(ns).toByteArray(), -1);
        }
        catch (KeeperException e) {
            LOG.error((Object)("Failed updating permissions for namespace " + ns.getName()), (Throwable)e);
            throw new IOException("Failed updating permissions for namespace " + ns.getName(), e);
        }
    }

    private void refreshNodes(List<ZKUtil.NodeAndData> nodes) throws IOException {
        for (ZKUtil.NodeAndData n : nodes) {
            if (n.isEmpty()) continue;
            String path = n.getNode();
            String namespace = ZKUtil.getNodeName(path);
            byte[] nodeData = n.getData();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Updating namespace cache from node " + namespace + " with data: " + Bytes.toStringBinary(nodeData)));
            }
            NamespaceDescriptor ns = ProtobufUtil.toNamespaceDescriptor(HBaseProtos.NamespaceDescriptor.parseFrom(nodeData));
            this.cache.put(ns.getName(), ns);
        }
    }
}

