/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.aws.credentials;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import java.util.Properties;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieAWSConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieConfigAWSCredentialsProvider
implements AWSCredentialsProvider {
    private static final Logger LOG = LogManager.getLogger(HoodieConfigAWSCredentialsProvider.class);
    private AWSCredentials awsCredentials;

    public HoodieConfigAWSCredentialsProvider(Properties props) {
        String accessKey = props.getProperty(HoodieAWSConfig.AWS_ACCESS_KEY.key());
        String secretKey = props.getProperty(HoodieAWSConfig.AWS_SECRET_KEY.key());
        String sessionToken = props.getProperty(HoodieAWSConfig.AWS_SESSION_TOKEN.key());
        if (StringUtils.isNullOrEmpty(accessKey) || StringUtils.isNullOrEmpty(secretKey)) {
            LOG.debug((Object)"AWS access key or secret key not found in the Hudi configuration. Use default AWS credentials");
        } else {
            this.awsCredentials = HoodieConfigAWSCredentialsProvider.createCredentials(accessKey, secretKey, sessionToken);
        }
    }

    private static AWSCredentials createCredentials(String accessKey, String secretKey, String sessionToken) {
        return sessionToken == null ? new BasicAWSCredentials(accessKey, secretKey) : new BasicSessionCredentials(accessKey, secretKey, sessionToken);
    }

    @Override
    public AWSCredentials getCredentials() {
        return this.awsCredentials;
    }

    @Override
    public void refresh() {
    }
}

