/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;
import org.apache.hudi.common.config.ConfigClassProperty;
import org.apache.hudi.common.config.ConfigGroups;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.exception.HoodieNotSupportedException;

@ConfigClassProperty(name="Metadata Configs", groupName=ConfigGroups.Names.WRITE_CLIENT, description="Configurations used by the Hudi Metadata Table. This table maintains the metadata about a given Hudi table (e.g file listings)  to avoid overhead of accessing cloud storage, during queries.")
@Immutable
public final class HoodieMetadataConfig
extends HoodieConfig {
    public static final String METADATA_PREFIX = "hoodie.metadata";
    public static final ConfigProperty<Boolean> ENABLE = ConfigProperty.key("hoodie.metadata.enable").defaultValue(false).sinceVersion("0.7.0").withDocumentation("Enable the internal metadata table which serves table metadata like level file listings");
    public static final boolean DEFAULT_METADATA_ENABLE_FOR_READERS = false;
    public static final ConfigProperty<Boolean> METRICS_ENABLE = ConfigProperty.key("hoodie.metadata.metrics.enable").defaultValue(false).sinceVersion("0.7.0").withDocumentation("Enable publishing of metrics around metadata table.");
    public static final ConfigProperty<Integer> INSERT_PARALLELISM_VALUE = ConfigProperty.key("hoodie.metadata.insert.parallelism").defaultValue(1).sinceVersion("0.7.0").withDocumentation("Parallelism to use when inserting to the metadata table");
    public static final ConfigProperty<Boolean> ASYNC_CLEAN_ENABLE = ConfigProperty.key("hoodie.metadata.clean.async").defaultValue(false).sinceVersion("0.7.0").withDocumentation("Enable asynchronous cleaning for metadata table");
    public static final ConfigProperty<Integer> COMPACT_NUM_DELTA_COMMITS = ConfigProperty.key("hoodie.metadata.compact.max.delta.commits").defaultValue(10).sinceVersion("0.7.0").withDocumentation("Controls how often the metadata table is compacted.");
    public static final ConfigProperty<Integer> MIN_COMMITS_TO_KEEP = ConfigProperty.key("hoodie.metadata.keep.min.commits").defaultValue(20).sinceVersion("0.7.0").withDocumentation("Controls the archival of the metadata table\u2019s timeline.");
    public static final ConfigProperty<Integer> MAX_COMMITS_TO_KEEP = ConfigProperty.key("hoodie.metadata.keep.max.commits").defaultValue(30).sinceVersion("0.7.0").withDocumentation("Controls the archival of the metadata table\u2019s timeline.");
    public static final ConfigProperty<Integer> CLEANER_COMMITS_RETAINED = ConfigProperty.key("hoodie.metadata.cleaner.commits.retained").defaultValue(3).sinceVersion("0.7.0").withDocumentation("Controls retention/history for metadata table.");
    public static final ConfigProperty<String> DIR_FILTER_REGEX = ConfigProperty.key("hoodie.metadata.dir.filter.regex").defaultValue("").sinceVersion("0.7.0").withDocumentation("Directories matching this regex, will be filtered out when initializing metadata table from lake storage for the first time.");
    public static final ConfigProperty<String> ASSUME_DATE_PARTITIONING = ConfigProperty.key("hoodie.assume.date.partitioning").defaultValue("false").sinceVersion("0.3.0").withDocumentation("Should HoodieWriteClient assume the data is partitioned by dates, i.e three levels from base path. This is a stop-gap to support tables created by versions < 0.3.1. Will be removed eventually");
    public static final ConfigProperty<Integer> FILE_LISTING_PARALLELISM_VALUE = ConfigProperty.key("hoodie.file.listing.parallelism").defaultValue(200).sinceVersion("0.7.0").withDocumentation("Parallelism to use, when listing the table on lake storage.");
    public static final ConfigProperty<Boolean> ENABLE_FULL_SCAN_LOG_FILES = ConfigProperty.key("hoodie.metadata.enable.full.scan.log.files").defaultValue(true).sinceVersion("0.10.0").withDocumentation("Enable full scanning of log files while reading log records. If disabled, hudi does look up of only interested entries.");
    public static final ConfigProperty<Boolean> POPULATE_META_FIELDS = ConfigProperty.key("hoodie.metadata.populate.meta.fields").defaultValue(true).sinceVersion("0.10.0").withDocumentation("When enabled, populates all meta fields. When disabled, no meta fields are populated.");
    public static final ConfigProperty<Boolean> IGNORE_SPURIOUS_DELETES = ConfigProperty.key("_hoodie.metadata.ignore.spurious.deletes").defaultValue(true).sinceVersion("0.10.10").withDocumentation("There are cases when extra files are requested to be deleted from metadata table which was never added before. This configdetermines how to handle such spurious deletes");
    @Deprecated
    public static final String METADATA_ENABLE_PROP = ENABLE.key();
    @Deprecated
    public static final boolean DEFAULT_METADATA_ENABLE = ENABLE.defaultValue();
    @Deprecated
    public static final String METADATA_METRICS_ENABLE_PROP = METRICS_ENABLE.key();
    @Deprecated
    public static final boolean DEFAULT_METADATA_METRICS_ENABLE = METRICS_ENABLE.defaultValue();
    @Deprecated
    public static final String METADATA_INSERT_PARALLELISM_PROP = INSERT_PARALLELISM_VALUE.key();
    @Deprecated
    public static final int DEFAULT_METADATA_INSERT_PARALLELISM = INSERT_PARALLELISM_VALUE.defaultValue();
    @Deprecated
    public static final String METADATA_ASYNC_CLEAN_PROP = ASYNC_CLEAN_ENABLE.key();
    @Deprecated
    public static final boolean DEFAULT_METADATA_ASYNC_CLEAN = ASYNC_CLEAN_ENABLE.defaultValue();
    @Deprecated
    public static final String METADATA_COMPACT_NUM_DELTA_COMMITS_PROP = COMPACT_NUM_DELTA_COMMITS.key();
    @Deprecated
    public static final int DEFAULT_METADATA_COMPACT_NUM_DELTA_COMMITS = COMPACT_NUM_DELTA_COMMITS.defaultValue();
    @Deprecated
    public static final String MIN_COMMITS_TO_KEEP_PROP = MIN_COMMITS_TO_KEEP.key();
    @Deprecated
    public static final int DEFAULT_MIN_COMMITS_TO_KEEP = MIN_COMMITS_TO_KEEP.defaultValue();
    @Deprecated
    public static final String MAX_COMMITS_TO_KEEP_PROP = MAX_COMMITS_TO_KEEP.key();
    @Deprecated
    public static final int DEFAULT_MAX_COMMITS_TO_KEEP = MAX_COMMITS_TO_KEEP.defaultValue();
    @Deprecated
    public static final String CLEANER_COMMITS_RETAINED_PROP = CLEANER_COMMITS_RETAINED.key();
    @Deprecated
    public static final int DEFAULT_CLEANER_COMMITS_RETAINED = CLEANER_COMMITS_RETAINED.defaultValue();
    @Deprecated
    public static final String ENABLE_FALLBACK_PROP = "hoodie.metadata.fallback.enable";
    @Deprecated
    public static final String DEFAULT_ENABLE_FALLBACK = "true";
    @Deprecated
    public static final String DIRECTORY_FILTER_REGEX = DIR_FILTER_REGEX.key();
    @Deprecated
    public static final String DEFAULT_DIRECTORY_FILTER_REGEX = DIR_FILTER_REGEX.defaultValue();
    @Deprecated
    public static final String HOODIE_ASSUME_DATE_PARTITIONING_PROP = ASSUME_DATE_PARTITIONING.key();
    @Deprecated
    public static final String DEFAULT_ASSUME_DATE_PARTITIONING = ASSUME_DATE_PARTITIONING.defaultValue();
    @Deprecated
    public static final String FILE_LISTING_PARALLELISM_PROP = FILE_LISTING_PARALLELISM_VALUE.key();
    @Deprecated
    public static final int DEFAULT_FILE_LISTING_PARALLELISM = FILE_LISTING_PARALLELISM_VALUE.defaultValue();

    private HoodieMetadataConfig() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int getFileListingParallelism() {
        return Math.max(this.getInt(FILE_LISTING_PARALLELISM_VALUE), 1);
    }

    public Boolean shouldAssumeDatePartitioning() {
        return this.getBoolean(ASSUME_DATE_PARTITIONING);
    }

    public boolean enabled() {
        return this.getBoolean(ENABLE);
    }

    public boolean enableMetrics() {
        return this.getBoolean(METRICS_ENABLE);
    }

    public String getDirectoryFilterRegex() {
        return this.getString(DIR_FILTER_REGEX);
    }

    public boolean enableFullScan() {
        return this.getBoolean(ENABLE_FULL_SCAN_LOG_FILES);
    }

    public boolean populateMetaFields() {
        return this.getBooleanOrDefault(POPULATE_META_FIELDS);
    }

    public boolean ignoreSpuriousDeletes() {
        return this.getBoolean(IGNORE_SPURIOUS_DELETES);
    }

    public static class Builder {
        private EngineType engineType = EngineType.SPARK;
        private final HoodieMetadataConfig metadataConfig = new HoodieMetadataConfig();

        public Builder fromFile(File propertiesFile) throws IOException {
            try (FileReader reader = new FileReader(propertiesFile);){
                this.metadataConfig.getProps().load(reader);
                Builder builder = this;
                return builder;
            }
        }

        public Builder fromProperties(Properties props) {
            this.metadataConfig.getProps().putAll((Map<?, ?>)props);
            return this;
        }

        public Builder enable(boolean enable) {
            this.metadataConfig.setValue(ENABLE, String.valueOf(enable));
            return this;
        }

        public Builder enableMetrics(boolean enableMetrics) {
            this.metadataConfig.setValue(METRICS_ENABLE, String.valueOf(enableMetrics));
            return this;
        }

        public Builder withInsertParallelism(int parallelism) {
            this.metadataConfig.setValue(INSERT_PARALLELISM_VALUE, String.valueOf(parallelism));
            return this;
        }

        public Builder withAsyncClean(boolean asyncClean) {
            this.metadataConfig.setValue(ASYNC_CLEAN_ENABLE, String.valueOf(asyncClean));
            return this;
        }

        public Builder withMaxNumDeltaCommitsBeforeCompaction(int maxNumDeltaCommitsBeforeCompaction) {
            this.metadataConfig.setValue(COMPACT_NUM_DELTA_COMMITS, String.valueOf(maxNumDeltaCommitsBeforeCompaction));
            return this;
        }

        public Builder withPopulateMetaFields(boolean populateMetaFields) {
            this.metadataConfig.setValue(POPULATE_META_FIELDS, Boolean.toString(populateMetaFields));
            return this;
        }

        public Builder archiveCommitsWith(int minToKeep, int maxToKeep) {
            this.metadataConfig.setValue(MIN_COMMITS_TO_KEEP, String.valueOf(minToKeep));
            this.metadataConfig.setValue(MAX_COMMITS_TO_KEEP, String.valueOf(maxToKeep));
            return this;
        }

        public Builder retainCommits(int commitsRetained) {
            this.metadataConfig.setValue(CLEANER_COMMITS_RETAINED, String.valueOf(commitsRetained));
            return this;
        }

        public Builder withFileListingParallelism(int parallelism) {
            this.metadataConfig.setValue(FILE_LISTING_PARALLELISM_VALUE, String.valueOf(parallelism));
            return this;
        }

        public Builder withAssumeDatePartitioning(boolean assumeDatePartitioning) {
            this.metadataConfig.setValue(ASSUME_DATE_PARTITIONING, String.valueOf(assumeDatePartitioning));
            return this;
        }

        public Builder withDirectoryFilterRegex(String regex) {
            this.metadataConfig.setValue(DIR_FILTER_REGEX, regex);
            return this;
        }

        public Builder enableFullScan(boolean enableFullScan) {
            this.metadataConfig.setValue(ENABLE_FULL_SCAN_LOG_FILES, String.valueOf(enableFullScan));
            return this;
        }

        public Builder ignoreSpuriousDeletes(boolean validateMetadataPayloadConsistency) {
            this.metadataConfig.setValue(IGNORE_SPURIOUS_DELETES, String.valueOf(validateMetadataPayloadConsistency));
            return this;
        }

        public Builder withEngineType(EngineType engineType) {
            this.engineType = engineType;
            return this;
        }

        public HoodieMetadataConfig build() {
            this.metadataConfig.setDefaultValue(ENABLE, this.getDefaultMetadataEnable(this.engineType));
            this.metadataConfig.setDefaults(HoodieMetadataConfig.class.getName());
            return this.metadataConfig;
        }

        private boolean getDefaultMetadataEnable(EngineType engineType) {
            switch (engineType) {
                case SPARK: {
                    return ENABLE.defaultValue();
                }
                case FLINK: 
                case JAVA: {
                    return false;
                }
            }
            throw new HoodieNotSupportedException("Unsupported engine " + (Object)((Object)engineType));
        }
    }
}

