/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution;

import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.utils.LazyIterableIterator;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.execution.CopyOnWriteInsertHandler;
import org.apache.hudi.io.CreateHandleFactory;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.HoodieTable;

public abstract class HoodieLazyInsertIterable<T extends HoodieRecordPayload>
extends LazyIterableIterator<HoodieRecord<T>, List<WriteStatus>> {
    protected final HoodieWriteConfig hoodieConfig;
    protected final String instantTime;
    protected boolean areRecordsSorted;
    protected final HoodieTable hoodieTable;
    protected final String idPrefix;
    protected TaskContextSupplier taskContextSupplier;
    protected WriteHandleFactory writeHandleFactory;

    public HoodieLazyInsertIterable(Iterator<HoodieRecord<T>> recordItr, boolean areRecordsSorted, HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier) {
        this(recordItr, areRecordsSorted, config, instantTime, hoodieTable, idPrefix, taskContextSupplier, new CreateHandleFactory());
    }

    public HoodieLazyInsertIterable(Iterator<HoodieRecord<T>> recordItr, boolean areRecordsSorted, HoodieWriteConfig config, String instantTime, HoodieTable hoodieTable, String idPrefix, TaskContextSupplier taskContextSupplier, WriteHandleFactory writeHandleFactory) {
        super(recordItr);
        this.areRecordsSorted = areRecordsSorted;
        this.hoodieConfig = config;
        this.instantTime = instantTime;
        this.hoodieTable = hoodieTable;
        this.idPrefix = idPrefix;
        this.taskContextSupplier = taskContextSupplier;
        this.writeHandleFactory = writeHandleFactory;
    }

    static <T extends HoodieRecordPayload> Function<HoodieRecord<T>, HoodieInsertValueGenResult<HoodieRecord>> getTransformFunction(Schema schema, HoodieWriteConfig config) {
        return hoodieRecord -> new HoodieInsertValueGenResult<HoodieRecord>((HoodieRecord)hoodieRecord, schema, config.getProps());
    }

    static <T extends HoodieRecordPayload> Function<HoodieRecord<T>, HoodieInsertValueGenResult<HoodieRecord>> getTransformFunction(Schema schema) {
        return hoodieRecord -> new HoodieInsertValueGenResult<HoodieRecord>((HoodieRecord)hoodieRecord, schema, CollectionUtils.EMPTY_PROPERTIES);
    }

    @Override
    protected void start() {
    }

    @Override
    protected void end() {
    }

    protected CopyOnWriteInsertHandler getInsertHandler() {
        return new CopyOnWriteInsertHandler(this.hoodieConfig, this.instantTime, this.areRecordsSorted, this.hoodieTable, this.idPrefix, this.taskContextSupplier, this.writeHandleFactory);
    }

    public static class HoodieInsertValueGenResult<T extends HoodieRecord> {
        public T record;
        public Option<IndexedRecord> insertValue;
        public Option<Exception> exception = Option.empty();

        public HoodieInsertValueGenResult(T record, Schema schema, Properties properties) {
            this.record = record;
            try {
                this.insertValue = ((HoodieRecord)record).getData().getInsertValue(schema, properties);
            }
            catch (Exception e) {
                this.exception = Option.of(e);
            }
        }
    }
}

