/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hadoop;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieColumnProjectionUtils {
    public static final Logger LOG = LoggerFactory.getLogger(ColumnProjectionUtils.class);
    public static final String READ_COLUMN_IDS_CONF_STR = "hive.io.file.readcolumn.ids";
    public static final String READ_NESTED_COLUMN_PATH_CONF_STR = "hive.io.file.readNestedColumn.paths";
    public static final String READ_ALL_COLUMNS = "hive.io.file.read.all.columns";
    public static final String READ_COLUMN_NAMES_CONF_STR = "hive.io.file.readcolumn.names";
    private static final String READ_COLUMN_IDS_CONF_STR_DEFAULT = "";
    private static final String READ_COLUMN_NAMES_CONF_STR_DEFAULT = "";
    private static final String READ_NESTED_COLUMN_PATH_CONF_STR_DEFAULT = "";
    private static final boolean READ_ALL_COLUMNS_DEFAULT = true;
    private static final String COMMA = ",";
    public static final String PARQUET_BLOCK_OFFSET_COL_NAME = "BLOCK__OFFSET__INSIDE__FILE";
    public static final String PARQUET_INPUT_FILE_NAME = "INPUT__FILE__NAME";
    public static final String PARQUET_ROW_ID = "ROW__ID";
    public static final List<String> PARQUET_SPECIAL_COLUMN_NAMES = CollectionUtils.createImmutableList("BLOCK__OFFSET__INSIDE__FILE", "INPUT__FILE__NAME", "ROW__ID");

    public static void setReadAllColumns(Configuration conf) {
        conf.setBoolean(READ_ALL_COLUMNS, true);
        HoodieColumnProjectionUtils.setReadColumnIDConf(conf, "");
        HoodieColumnProjectionUtils.setReadColumnNamesConf(conf, "");
    }

    public static boolean isReadAllColumns(Configuration conf) {
        return conf.getBoolean(READ_ALL_COLUMNS, true);
    }

    public static void setReadColumns(Configuration conf, List<Integer> ids, List<String> names) {
        HoodieColumnProjectionUtils.setReadColumnIDConf(conf, "");
        HoodieColumnProjectionUtils.setReadColumnNamesConf(conf, "");
        HoodieColumnProjectionUtils.appendReadColumns(conf, ids);
        HoodieColumnProjectionUtils.appendReadColumnNames(conf, names);
    }

    public static void appendReadColumns(Configuration conf, List<Integer> ids) {
        String id = HoodieColumnProjectionUtils.toReadColumnIDString(ids);
        String old = conf.get(READ_COLUMN_IDS_CONF_STR, null);
        String newConfStr = id;
        if (old != null && !old.isEmpty()) {
            newConfStr = newConfStr + COMMA + old;
        }
        HoodieColumnProjectionUtils.setReadColumnIDConf(conf, newConfStr);
        conf.setBoolean(READ_ALL_COLUMNS, false);
    }

    public static void appendNestedColumnPaths(Configuration conf, List<String> paths) {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        String pathsStr = StringUtils.join((CharSequence)COMMA, (String[])paths.toArray(new String[paths.size()]));
        String old = conf.get(READ_NESTED_COLUMN_PATH_CONF_STR, null);
        String newConfStr = pathsStr;
        if (old != null && !old.isEmpty()) {
            newConfStr = newConfStr + COMMA + old;
        }
        HoodieColumnProjectionUtils.setReadNestedColumnPathConf(conf, newConfStr);
    }

    public static void appendReadColumns(Configuration conf, List<Integer> ids, List<String> names, List<String> groupPaths) {
        if (ids.size() != names.size()) {
            LOG.warn("Read column counts do not match: " + ids.size() + " ids, " + names.size() + " names");
        }
        HoodieColumnProjectionUtils.appendReadColumns(conf, ids);
        HoodieColumnProjectionUtils.appendReadColumnNames(conf, names);
        HoodieColumnProjectionUtils.appendNestedColumnPaths(conf, groupPaths);
    }

    public static void appendReadColumns(StringBuilder readColumnsBuffer, StringBuilder readColumnNamesBuffer, List<Integer> ids, List<String> names) {
        String preppedIdStr = ids.stream().map(x -> String.valueOf(x)).collect(Collectors.joining(COMMA));
        String preppedNamesStr = names.stream().collect(Collectors.joining(COMMA));
        if (readColumnsBuffer.length() > 0) {
            readColumnsBuffer.append(COMMA);
        }
        readColumnsBuffer.append(preppedIdStr);
        if (readColumnNamesBuffer.length() > 0) {
            readColumnNamesBuffer.append(COMMA);
        }
        readColumnNamesBuffer.append(preppedNamesStr);
    }

    public static List<Integer> getReadColumnIDs(Configuration conf) {
        String skips = conf.get(READ_COLUMN_IDS_CONF_STR, "");
        String[] list = StringUtils.split((String)skips);
        ArrayList<Integer> result = new ArrayList<Integer>(list.length);
        for (String element : list) {
            Integer toAdd = Integer.parseInt(element);
            if (result.contains(toAdd)) continue;
            result.add(toAdd);
        }
        return result;
    }

    public static Set<String> getNestedColumnPaths(Configuration conf) {
        String skips = conf.get(READ_NESTED_COLUMN_PATH_CONF_STR, "");
        return new HashSet<String>(Arrays.asList(StringUtils.split((String)skips)));
    }

    public static String[] getReadColumnNames(Configuration conf) {
        String colNames = conf.get(READ_COLUMN_NAMES_CONF_STR, "");
        if (colNames != null && !colNames.isEmpty()) {
            return colNames.split(COMMA);
        }
        return new String[0];
    }

    public static List<String> getIOColumns(Configuration conf) {
        String colNames = conf.get("columns", "");
        if (colNames != null && !colNames.isEmpty()) {
            return Arrays.asList(colNames.split(COMMA));
        }
        return new ArrayList<String>();
    }

    public static List<String> getIOColumnTypes(Configuration conf) {
        String colTypes = conf.get("columns.types", "");
        if (colTypes != null && !colTypes.isEmpty()) {
            return TypeInfoUtils.getTypeInfosFromTypeString((String)colTypes).stream().map(t -> t.getTypeName()).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public static List<Pair<String, String>> getIOColumnNameAndTypes(Configuration conf) {
        List<String> names = HoodieColumnProjectionUtils.getIOColumns(conf);
        List<String> types = HoodieColumnProjectionUtils.getIOColumnTypes(conf);
        ValidationUtils.checkArgument(names.size() == types.size());
        return IntStream.range(0, names.size()).mapToObj(idx -> Pair.of(names.get(idx), types.get(idx))).collect(Collectors.toList());
    }

    public static void setIOColumnNameAndTypes(Configuration conf, List<Pair<String, String>> colNamesAndTypes) {
        String colNames = colNamesAndTypes.stream().map(e -> (String)e.getKey()).collect(Collectors.joining(COMMA));
        String colTypes = colNamesAndTypes.stream().map(e -> (String)e.getValue()).collect(Collectors.joining(COMMA));
        conf.set("columns", colNames);
        conf.set("columns.types", colTypes);
    }

    private static void setReadColumnIDConf(Configuration conf, String id) {
        if (id.trim().isEmpty()) {
            conf.set(READ_COLUMN_IDS_CONF_STR, "");
        } else {
            conf.set(READ_COLUMN_IDS_CONF_STR, id);
        }
    }

    private static void setReadColumnNamesConf(Configuration conf, String id) {
        if (id.trim().isEmpty()) {
            conf.set(READ_COLUMN_NAMES_CONF_STR, "");
        } else {
            conf.set(READ_COLUMN_NAMES_CONF_STR, id);
        }
    }

    private static void setReadNestedColumnPathConf(Configuration conf, String nestedColumnPaths) {
        if ((nestedColumnPaths = nestedColumnPaths.toLowerCase()).trim().isEmpty()) {
            conf.set(READ_NESTED_COLUMN_PATH_CONF_STR, "");
        } else {
            conf.set(READ_NESTED_COLUMN_PATH_CONF_STR, nestedColumnPaths);
        }
    }

    private static void appendReadColumnNames(Configuration conf, List<String> cols) {
        String old = conf.get(READ_COLUMN_NAMES_CONF_STR, "");
        StringBuilder result = new StringBuilder(old);
        boolean first = old.isEmpty();
        for (String col : cols) {
            if (first) {
                first = false;
            } else {
                result.append(',');
            }
            result.append(col);
        }
        conf.set(READ_COLUMN_NAMES_CONF_STR, result.toString());
    }

    private static String toReadColumnIDString(List<Integer> ids) {
        String id = "";
        for (int i = 0; i < ids.size(); ++i) {
            id = i == 0 ? id + ids.get(i) : id + COMMA + ids.get(i);
        }
        return id;
    }

    public static boolean supportTimestamp(Configuration conf) {
        List<String> reads = Arrays.asList(HoodieColumnProjectionUtils.getReadColumnNames(conf));
        if (reads.isEmpty()) {
            return HoodieColumnProjectionUtils.getIOColumnTypes(conf).contains("timestamp");
        }
        List<String> names = HoodieColumnProjectionUtils.getIOColumns(conf);
        List<String> types = HoodieColumnProjectionUtils.getIOColumnTypes(conf);
        return types.isEmpty() || IntStream.range(0, names.size()).filter(i -> reads.contains(names.get(i))).anyMatch(i -> ((String)types.get(i)).equals("timestamp"));
    }
}

