/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bloom;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.index.bloom.BaseHoodieBloomIndexHelper;
import org.apache.hudi.index.bloom.BloomIndexFileInfo;
import org.apache.hudi.index.bloom.HoodieBloomIndex;
import org.apache.hudi.index.bloom.IndexFileFilter;
import org.apache.hudi.index.bloom.IntervalTreeBasedGlobalIndexFileFilter;
import org.apache.hudi.index.bloom.ListBasedGlobalIndexFileFilter;
import org.apache.hudi.table.HoodieTable;

public class HoodieGlobalBloomIndex<T extends HoodieRecordPayload<T>>
extends HoodieBloomIndex<T> {
    public HoodieGlobalBloomIndex(HoodieWriteConfig config, BaseHoodieBloomIndexHelper bloomIndexHelper) {
        super(config, bloomIndexHelper);
    }

    @Override
    List<Pair<String, BloomIndexFileInfo>> loadInvolvedFiles(List<String> partitions, HoodieEngineContext context, HoodieTable hoodieTable) {
        HoodieTableMetaClient metaClient = hoodieTable.getMetaClient();
        List<String> allPartitionPaths = FSUtils.getAllPartitionPaths(context, this.config.getMetadataConfig(), metaClient.getBasePath());
        return super.loadInvolvedFiles(allPartitionPaths, context, hoodieTable);
    }

    @Override
    HoodieData<ImmutablePair<String, HoodieKey>> explodeRecordsWithFileComparisons(Map<String, List<BloomIndexFileInfo>> partitionToFileIndexInfo, HoodiePairData<String, String> partitionRecordKeyPairs) {
        IndexFileFilter indexFileFilter = this.config.useBloomIndexTreebasedFilter() ? new IntervalTreeBasedGlobalIndexFileFilter(partitionToFileIndexInfo) : new ListBasedGlobalIndexFileFilter(partitionToFileIndexInfo);
        return partitionRecordKeyPairs.map(partitionRecordKeyPair -> {
            String recordKey = (String)partitionRecordKeyPair.getRight();
            String partitionPath = (String)partitionRecordKeyPair.getLeft();
            return indexFileFilter.getMatchingFilesAndPartition(partitionPath, recordKey).stream().map(partitionFileIdPair -> new ImmutablePair(partitionFileIdPair.getRight(), new HoodieKey(recordKey, (String)partitionFileIdPair.getLeft()))).collect(Collectors.toList());
        }).flatMap(List::iterator);
    }

    @Override
    protected HoodieData<HoodieRecord<T>> tagLocationBacktoRecords(HoodiePairData<HoodieKey, HoodieRecordLocation> keyLocationPairs, HoodieData<HoodieRecord<T>> records) {
        HoodiePairData incomingRowKeyRecordPairs = records.mapToPair(record -> new ImmutablePair<String, HoodieRecord>(record.getRecordKey(), (HoodieRecord)record));
        HoodiePairData existingRecordKeyToRecordLocationHoodieKeyMap = keyLocationPairs.mapToPair(p -> new ImmutablePair(((HoodieKey)p.getKey()).getRecordKey(), new ImmutablePair(p.getValue(), p.getKey())));
        return incomingRowKeyRecordPairs.leftOuterJoin(existingRecordKeyToRecordLocationHoodieKeyMap).values().flatMap(record -> {
            HoodieRecord hoodieRecord = (HoodieRecord)record.getLeft();
            Option recordLocationHoodieKeyPair = (Option)record.getRight();
            if (recordLocationHoodieKeyPair.isPresent()) {
                if (this.config.getBloomIndexUpdatePartitionPath() && !((HoodieKey)((Pair)recordLocationHoodieKeyPair.get()).getRight()).getPartitionPath().equals(hoodieRecord.getPartitionPath())) {
                    HoodieRecord<EmptyHoodieRecordPayload> deleteRecord = new HoodieRecord<EmptyHoodieRecordPayload>((HoodieKey)((Pair)recordLocationHoodieKeyPair.get()).getRight(), new EmptyHoodieRecordPayload());
                    deleteRecord.setCurrentLocation((HoodieRecordLocation)((Pair)recordLocationHoodieKeyPair.get()).getLeft());
                    deleteRecord.seal();
                    HoodieRecord insertRecord = HoodieIndexUtils.getTaggedRecord(hoodieRecord, Option.empty());
                    return Arrays.asList(deleteRecord, insertRecord).iterator();
                }
                return Collections.singletonList(HoodieIndexUtils.getTaggedRecord(new HoodieRecord((HoodieKey)((Pair)recordLocationHoodieKeyPair.get()).getRight(), hoodieRecord.getData()), Option.ofNullable(((Pair)recordLocationHoodieKeyPair.get()).getLeft()))).iterator();
            }
            return Collections.singletonList(HoodieIndexUtils.getTaggedRecord(hoodieRecord, Option.empty())).iterator();
        });
    }

    @Override
    public boolean isGlobal() {
        return true;
    }
}

