/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.prometheus.client.dropwizard.samplebuilder;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class GraphiteNamePattern {
    private static final Pattern VALIDATION_PATTERN = Pattern.compile("^(\\*\\.|[a-zA-Z_0-9](-?[a-zA-Z0-9_])+\\.)+(\\*|[a-zA-Z_0-9](-?[a-zA-Z0-9_])+)$");
    private Pattern pattern;
    private String patternStr;

    GraphiteNamePattern(String pattern) throws IllegalArgumentException {
        if (!VALIDATION_PATTERN.matcher(pattern).matches()) {
            throw new IllegalArgumentException(String.format("Provided pattern [%s] does not matches [%s]", pattern, "^(\\*\\.|[a-zA-Z_0-9](-?[a-zA-Z0-9_])+\\.)+(\\*|[a-zA-Z_0-9](-?[a-zA-Z0-9_])+)$"));
        }
        this.initializePattern(pattern);
    }

    boolean matches(String metricName) {
        return metricName != null && this.pattern.matcher(metricName).matches();
    }

    Map<String, String> extractParameters(String metricName) {
        Matcher matcher = this.pattern.matcher(metricName);
        HashMap<String, String> params = new HashMap<String, String>();
        if (matcher.find()) {
            for (int i = 1; i <= matcher.groupCount(); ++i) {
                params.put(String.format("${%d}", i - 1), matcher.group(i));
            }
        }
        return params;
    }

    private void initializePattern(String pattern) {
        String regex;
        String[] split = pattern.split(Pattern.quote("*"), -1);
        StringBuilder escapedPattern = new StringBuilder(Pattern.quote(split[0]));
        for (int i = 1; i < split.length; ++i) {
            String quoted = Pattern.quote(split[i]);
            escapedPattern.append("([^.]*)").append(quoted);
        }
        this.patternStr = regex = "^" + escapedPattern.toString() + "$";
        this.pattern = Pattern.compile(regex);
    }

    String getPatternString() {
        return this.patternStr;
    }
}

