/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.spark.org.apache.spark.sql.avro;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.FileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.DatumReader;
import org.apache.avro.mapred.FsInput;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hudi.spark.org.apache.spark.sql.avro.AvroOptions;
import org.apache.hudi.spark.org.apache.spark.sql.avro.AvroOptions$;
import org.apache.hudi.spark.org.apache.spark.sql.avro.AvroOutputWriterFactory;
import org.apache.hudi.spark.org.apache.spark.sql.avro.IncompatibleSchemaException;
import org.apache.hudi.spark.org.apache.spark.sql.avro.IncompatibleSchemaException$;
import org.apache.hudi.spark.org.apache.spark.sql.avro.SchemaConverters$;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.NullType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class AvroUtils$
implements Logging {
    public static AvroUtils$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new AvroUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<StructType> inferSchema(SparkSession spark, Map<String, String> options, Seq<FileStatus> files) {
        Configuration conf = spark.sessionState().newHadoopConfWithOptions(options);
        AvroOptions parsedOptions = new AvroOptions(options, conf);
        if (parsedOptions.parameters().contains(AvroOptions$.MODULE$.ignoreExtensionKey())) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(105).append("Option ").append(AvroOptions$.MODULE$.ignoreExtensionKey()).append(" is deprecated. Please use the ").append("general data source option pathGlobFilter for filtering file names.").toString());
        }
        Schema.Parser parser = new Schema.Parser();
        Schema avroSchema = (Schema)parsedOptions.schema().map((Function1 & Serializable & scala.Serializable)x$1 -> parser.parse(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> MODULE$.inferAvroSchemaFromFiles(files, conf, parsedOptions.ignoreExtension(), spark.sessionState().conf().ignoreCorruptFiles()));
        DataType dataType = SchemaConverters$.MODULE$.toSqlType(avroSchema).dataType();
        if (!(dataType instanceof StructType)) {
            throw new RuntimeException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(97).append("Avro schema cannot be converted to a Spark SQL StructType:\n           |\n           |").append(avroSchema.toString(true)).append("\n           |").toString())).stripMargin());
        }
        StructType structType = (StructType)dataType;
        Some some = new Some((Object)structType);
        return some;
    }

    public boolean supportsDataType(DataType dataType) {
        boolean bl;
        block6: {
            DataType dataType2;
            while (true) {
                if ((dataType2 = dataType) instanceof AtomicType) {
                    bl = true;
                    break block6;
                }
                if (dataType2 instanceof StructType) {
                    StructType structType = (StructType)dataType2;
                    bl = structType.forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)AvroUtils$.MODULE$.supportsDataType(f.dataType())));
                    break block6;
                }
                if (dataType2 instanceof ArrayType) {
                    DataType elementType;
                    ArrayType arrayType = (ArrayType)dataType2;
                    dataType = elementType = arrayType.elementType();
                    continue;
                }
                if (dataType2 instanceof MapType) {
                    MapType mapType = (MapType)dataType2;
                    DataType keyType = mapType.keyType();
                    DataType valueType = mapType.valueType();
                    if (this.supportsDataType(keyType)) {
                        dataType = valueType;
                        continue;
                    }
                    bl = false;
                    break block6;
                }
                if (!(dataType2 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                dataType = userDefinedType.sqlType();
            }
            bl = dataType2 instanceof NullType;
        }
        return bl;
    }

    public OutputWriterFactory prepareWrite(SQLConf sqlConf, Job job, Map<String, String> options, StructType dataSchema) {
        AvroOptions parsedOptions = new AvroOptions(options, job.getConfiguration());
        Schema.Parser parser = new Schema.Parser();
        Schema outputAvroSchema = (Schema)parsedOptions.schema().map((Function1 & Serializable & scala.Serializable)x$1 -> parser.parse(x$1)).getOrElse((Function0 & Serializable & scala.Serializable)() -> SchemaConverters$.MODULE$.toAvroType((DataType)dataSchema, false, parsedOptions.recordName(), parsedOptions.recordNamespace()));
        AvroJob.setOutputKeySchema((Job)job, (Schema)outputAvroSchema);
        String string = parsedOptions.compression();
        String string2 = "uncompressed";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            job.getConfiguration().setBoolean("mapred.output.compress", false);
        } else {
            String string3;
            job.getConfiguration().setBoolean("mapred.output.compress", true);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Compressing Avro output using the ").append(parsedOptions.compression()).append(" codec").toString());
            String string4 = parsedOptions.compression();
            if ("deflate".equals(string4)) {
                int deflateLevel = sqlConf.avroDeflateLevel();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Avro compression level ").append(deflateLevel).append(" will be used for ").append("deflate").append(" codec.").toString());
                job.getConfiguration().setInt("avro.mapred.deflate.level", deflateLevel);
                string3 = "deflate";
            } else {
                boolean bl = "snappy".equals(string4) ? true : ("bzip2".equals(string4) ? true : "xz".equals(string4));
                if (bl) {
                    string3 = string4;
                } else {
                    throw new IllegalArgumentException(new StringBuilder(27).append("Invalid compression codec: ").append(string4).toString());
                }
            }
            String codec = string3;
            job.getConfiguration().set("avro.output.codec", codec);
        }
        return new AvroOutputWriterFactory(dataSchema, outputAvroSchema.toString());
    }

    private Schema inferAvroSchemaFromFiles(Seq<FileStatus> files, Configuration conf, boolean ignoreExtension, boolean ignoreCorruptFiles) {
        Schema schema;
        Option avroReader = files.iterator().map((Function1 & Serializable & scala.Serializable)f -> {
            Path path = f.getPath();
            return !ignoreExtension && !path.getName().endsWith(".avro") ? None$.MODULE$ : (Option)Utils$.MODULE$.tryWithResource((Function0 & Serializable & scala.Serializable)() -> new FsInput(path, conf), (Function1 & Serializable & scala.Serializable)in -> {
                Some some;
                try {
                    some = new Some((Object)DataFileReader.openReader((SeekableInput)in, (DatumReader)new GenericDatumReader()));
                }
                catch (IOException e) {
                    if (ignoreCorruptFiles) {
                        MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Skipped the footer in the corrupted file: ").append(path).toString(), e);
                        some = None$.MODULE$;
                    }
                    throw new SparkException(new StringBuilder(21).append("Could not read file: ").append(path).toString(), (Throwable)e);
                }
                return some;
            });
        }).collectFirst((PartialFunction)new scala.Serializable(){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Option<FileReader<GenericRecord>>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Some) {
                    Some some = (Some)A1;
                    FileReader reader = (FileReader)some.value();
                    object = reader;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Option<FileReader<GenericRecord>> x1) {
                Option<FileReader<GenericRecord>> option = x1;
                boolean bl = option instanceof Some;
                return bl;
            }
        });
        Option option = avroReader;
        if (option instanceof Some) {
            Some some = (Some)option;
            try (FileReader reader = (FileReader)some.value();){
                schema = reader.getSchema();
            }
        } else {
            if (None$.MODULE$.equals(option)) {
                throw new FileNotFoundException("No Avro files found. If files don't have .avro extension, set ignoreExtension to true");
            }
            throw new MatchError((Object)option);
        }
        Schema schema2 = schema;
        return schema2;
    }

    public Option<Schema.Field> getAvroFieldByName(Schema avroSchema, String name) {
        None$ none$;
        Schema.Type type = avroSchema.getType();
        Schema.Type type2 = Schema.Type.RECORD;
        if (type == null ? type2 != null : !type.equals(type2)) {
            throw new IncompatibleSchemaException(new StringBuilder(46).append("Attempting to treat ").append(avroSchema.getName()).append(" as a RECORD, but it was: ").append(avroSchema.getType()).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
        }
        Seq seq = ((SeqLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getFields()).asScala()).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)AvroUtils$.$anonfun$getAvroFieldByName$1(name, f)))).toSeq();
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(1) == 0) {
            Schema.Field avroField = (Schema.Field)((SeqLike)some.get()).apply(0);
            none$ = new Some((Object)avroField);
        } else {
            Some some2 = Seq$.MODULE$.unapplySeq(seq);
            if (!some2.isEmpty() && some2.get() != null && ((SeqLike)some2.get()).lengthCompare(0) == 0) {
                none$ = None$.MODULE$;
            } else {
                throw new IncompatibleSchemaException(new StringBuilder(59).append("Searching for '").append(name).append("' in Avro schema gave ").append(seq.size()).append(" matches. Candidates: ").append(((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]")).toString(), IncompatibleSchemaException$.MODULE$.$lessinit$greater$default$2());
            }
        }
        return none$;
    }

    public static final /* synthetic */ boolean $anonfun$getAvroFieldByName$1(String name$1, Schema.Field f) {
        return BoxesRunTime.unboxToBoolean((Object)SQLConf$.MODULE$.get().resolver().apply((Object)f.name(), (Object)name$1));
    }

    private AvroUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

