/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.spark3.internal;

import java.util.Map;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.config.HoodieInternalConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.internal.BaseDefaultSource;
import org.apache.hudi.spark3.internal.HoodieDataSourceInternalTable;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.connector.expressions.Transform;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;

public class DefaultSource
extends BaseDefaultSource
implements TableProvider {
    public StructType inferSchema(CaseInsensitiveStringMap options) {
        return StructType.fromDDL((String)options.get((Object)HoodieInternalConfig.BULKINSERT_INPUT_DATA_SCHEMA_DDL.key()));
    }

    public Table getTable(StructType schema, Transform[] partitioning, Map<String, String> properties) {
        String instantTime = properties.get("hoodie.instant.time");
        String path = properties.get("path");
        String tblName = properties.get(HoodieWriteConfig.TBL_NAME.key());
        boolean populateMetaFields = Boolean.parseBoolean(properties.getOrDefault(HoodieTableConfig.POPULATE_META_FIELDS.key(), HoodieTableConfig.POPULATE_META_FIELDS.defaultValue()));
        boolean arePartitionRecordsSorted = Boolean.parseBoolean(properties.getOrDefault("hoodie.bulkinsert.are.partitioner.records.sorted", Boolean.toString(HoodieInternalConfig.DEFAULT_BULKINSERT_ARE_PARTITIONER_RECORDS_SORTED)));
        HoodieWriteConfig config = DataSourceUtils.createHoodieConfig(properties.get(HoodieWriteConfig.AVRO_SCHEMA_STRING.key()), path, tblName, properties);
        return new HoodieDataSourceInternalTable(instantTime, config, schema, this.getSparkSession(), this.getConfiguration(), properties, populateMetaFields, arePartitionRecordsSorted);
    }
}

