/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.DataSourceUtils;
import org.apache.hudi.HoodieWriterUtils$;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.AlterHoodieTableAddColumnsCommand;
import org.apache.spark.sql.types.StructField;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;

public final class AlterHoodieTableAddColumnsCommand$
implements Serializable {
    public static AlterHoodieTableAddColumnsCommand$ MODULE$;

    static {
        new AlterHoodieTableAddColumnsCommand$();
    }

    public void commitWithSchema(Schema schema, HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession) {
        JavaSparkContext jsc = new JavaSparkContext(sparkSession.sparkContext());
        SparkRDDWriteClient client = DataSourceUtils.createHoodieClient(jsc, schema.toString(), hoodieCatalogTable.tableLocation(), hoodieCatalogTable.tableName(), (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(HoodieWriterUtils$.MODULE$.parametersWithWriteDefaults(hoodieCatalogTable.catalogProperties())).asJava());
        String commitActionType = CommitUtils.getCommitActionType(WriteOperationType.INSERT, hoodieCatalogTable.tableType());
        String instantTime = HoodieActiveTimeline.createNewInstantTime();
        client.startCommitWithTime(instantTime, commitActionType);
        HoodieSparkTable hoodieTable = HoodieSparkTable.create(client.getConfig(), client.getEngineContext());
        HoodieActiveTimeline timeLine = hoodieTable.getActiveTimeline();
        HoodieInstant requested = new HoodieInstant(HoodieInstant.State.REQUESTED, commitActionType, instantTime);
        HoodieCommitMetadata metadata = new HoodieCommitMetadata();
        metadata.setOperationType(WriteOperationType.INSERT);
        timeLine.transitionRequestedToInflight(requested, org.apache.hudi.common.util.Option.of(metadata.toJsonString().getBytes(StandardCharsets.UTF_8)));
        client.commit(instantTime, jsc.emptyRDD());
    }

    public AlterHoodieTableAddColumnsCommand apply(TableIdentifier tableId, Seq<StructField> colsToAdd) {
        return new AlterHoodieTableAddColumnsCommand(tableId, colsToAdd);
    }

    public Option<Tuple2<TableIdentifier, Seq<StructField>>> unapply(AlterHoodieTableAddColumnsCommand x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.tableId(), x$0.colsToAdd()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AlterHoodieTableAddColumnsCommand$() {
        MODULE$ = this;
    }
}

