/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.HConstants;
import io.hops.hudi.org.apache.hadoop.hbase.HRegionLocation;
import io.hops.hudi.org.apache.hadoop.hbase.MetaTableAccessor;
import io.hops.hudi.org.apache.hadoop.hbase.RegionLocations;
import io.hops.hudi.org.apache.hadoop.hbase.ServerName;
import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.AdvancedScanResultConsumer;
import io.hops.hudi.org.apache.hadoop.hbase.client.AsyncTable;
import io.hops.hudi.org.apache.hadoop.hbase.client.Consistency;
import io.hops.hudi.org.apache.hadoop.hbase.client.Get;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionReplicaUtil;
import io.hops.hudi.org.apache.hadoop.hbase.client.Result;
import io.hops.hudi.org.apache.hadoop.hbase.client.Scan;
import io.hops.hudi.org.apache.hadoop.hbase.client.TableState;
import io.hops.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import io.hops.hudi.org.apache.hadoop.hbase.util.FutureUtils;
import io.hops.hudi.org.apache.hadoop.hbase.util.Pair;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AsyncMetaTableAccessor {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncMetaTableAccessor.class);
    private static final char META_REPLICA_ID_DELIMITER = '_';
    private static final Pattern SERVER_COLUMN_PATTERN = Pattern.compile("^server(_[0-9a-fA-F]{4})?$");

    public static CompletableFuture<Boolean> tableExists(AsyncTable<?> metaTable, TableName tableName) {
        return AsyncMetaTableAccessor.getTableState(metaTable, tableName).thenApply(Optional::isPresent);
    }

    public static CompletableFuture<Optional<TableState>> getTableState(AsyncTable<?> metaTable, TableName tableName) {
        CompletableFuture<Optional<TableState>> future = new CompletableFuture<Optional<TableState>>();
        Get get2 = new Get(tableName.getName()).addColumn(AsyncMetaTableAccessor.getTableFamily(), AsyncMetaTableAccessor.getStateColumn());
        long time = EnvironmentEdgeManager.currentTime();
        try {
            get2.setTimeRange(0L, time);
            FutureUtils.addListener(metaTable.get(get2), (result, error) -> {
                if (error != null) {
                    future.completeExceptionally((Throwable)error);
                    return;
                }
                try {
                    future.complete(AsyncMetaTableAccessor.getTableState(result));
                }
                catch (IOException e) {
                    future.completeExceptionally(e);
                }
            });
        }
        catch (IOException ioe) {
            future.completeExceptionally(ioe);
        }
        return future;
    }

    public static CompletableFuture<Optional<HRegionLocation>> getRegionLocation(AsyncTable<?> metaTable, byte[] regionName) {
        CompletableFuture<Optional<HRegionLocation>> future = new CompletableFuture<Optional<HRegionLocation>>();
        try {
            RegionInfo parsedRegionInfo = MetaTableAccessor.parseRegionInfoFromRegionName(regionName);
            FutureUtils.addListener(metaTable.get(new Get(MetaTableAccessor.getMetaKeyForRegion(parsedRegionInfo)).addFamily(HConstants.CATALOG_FAMILY)), (r, err) -> {
                if (err != null) {
                    future.completeExceptionally((Throwable)err);
                    return;
                }
                future.complete(AsyncMetaTableAccessor.getRegionLocations(r).map(locations -> locations.getRegionLocation(parsedRegionInfo.getReplicaId())));
            });
        }
        catch (IOException parseEx) {
            LOG.warn("Failed to parse the passed region name: " + Bytes.toStringBinary(regionName));
            future.completeExceptionally(parseEx);
        }
        return future;
    }

    public static CompletableFuture<Optional<HRegionLocation>> getRegionLocationWithEncodedName(AsyncTable<?> metaTable, byte[] encodedRegionName) {
        CompletableFuture<Optional<HRegionLocation>> future = new CompletableFuture<Optional<HRegionLocation>>();
        FutureUtils.addListener(metaTable.scanAll(new Scan().setReadType(Scan.ReadType.PREAD).addFamily(HConstants.CATALOG_FAMILY)), (results, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
                return;
            }
            String encodedRegionNameStr = Bytes.toString(encodedRegionName);
            results.stream().filter(result -> !result.isEmpty()).filter(result -> MetaTableAccessor.getRegionInfo(result) != null).forEach(result -> AsyncMetaTableAccessor.getRegionLocations(result).ifPresent(locations -> {
                for (HRegionLocation location : locations.getRegionLocations()) {
                    if (location == null || !encodedRegionNameStr.equals(location.getRegion().getEncodedName())) continue;
                    future.complete(Optional.of(location));
                    return;
                }
            }));
            future.complete(Optional.empty());
        });
        return future;
    }

    private static Optional<TableState> getTableState(Result r) throws IOException {
        Cell cell = r.getColumnLatestCell(AsyncMetaTableAccessor.getTableFamily(), AsyncMetaTableAccessor.getStateColumn());
        if (cell == null) {
            return Optional.empty();
        }
        try {
            return Optional.of(TableState.parseFrom(TableName.valueOf(r.getRow()), Arrays.copyOfRange(cell.getValueArray(), cell.getValueOffset(), cell.getValueOffset() + cell.getValueLength())));
        }
        catch (DeserializationException e) {
            throw new IOException("Failed to parse table state from result: " + r, e);
        }
    }

    public static CompletableFuture<List<HRegionLocation>> getTableHRegionLocations(AsyncTable<AdvancedScanResultConsumer> metaTable, TableName tableName) {
        CompletableFuture<List<HRegionLocation>> future = new CompletableFuture<List<HRegionLocation>>();
        FutureUtils.addListener(AsyncMetaTableAccessor.getTableRegionsAndLocations(metaTable, tableName, true), (locations, err) -> {
            if (err != null) {
                future.completeExceptionally((Throwable)err);
            } else if (locations == null || locations.isEmpty()) {
                future.complete(Collections.emptyList());
            } else {
                List regionLocations = locations.stream().map(loc -> new HRegionLocation((RegionInfo)loc.getFirst(), (ServerName)loc.getSecond())).collect(Collectors.toList());
                future.complete(regionLocations);
            }
        });
        return future;
    }

    private static CompletableFuture<List<Pair<RegionInfo, ServerName>>> getTableRegionsAndLocations(AsyncTable<AdvancedScanResultConsumer> metaTable, TableName tableName, final boolean excludeOfflinedSplitParents) {
        CompletableFuture<List<Pair<RegionInfo, ServerName>>> future = new CompletableFuture<List<Pair<RegionInfo, ServerName>>>();
        if (TableName.META_TABLE_NAME.equals(tableName)) {
            future.completeExceptionally(new IOException("This method can't be used to locate meta regions; use MetaTableLocator instead"));
        }
        MetaTableAccessor.CollectingVisitor<Pair<RegionInfo, ServerName>> visitor = new MetaTableAccessor.CollectingVisitor<Pair<RegionInfo, ServerName>>(){
            private RegionLocations current = null;

            @Override
            public boolean visit(Result r) throws IOException {
                Optional currentRegionLocations = AsyncMetaTableAccessor.getRegionLocations(r);
                this.current = currentRegionLocations.orElse(null);
                if (this.current == null || this.current.getRegionLocation().getRegion() == null) {
                    LOG.warn("No serialized RegionInfo in " + r);
                    return true;
                }
                RegionInfo hri = this.current.getRegionLocation().getRegion();
                if (excludeOfflinedSplitParents && hri.isSplitParent()) {
                    return true;
                }
                return super.visit(r);
            }

            @Override
            void add(Result r) {
                if (this.current == null) {
                    return;
                }
                for (HRegionLocation loc : this.current.getRegionLocations()) {
                    if (loc == null) continue;
                    this.results.add(new Pair<RegionInfo, ServerName>(loc.getRegion(), loc.getServerName()));
                }
            }
        };
        FutureUtils.addListener(AsyncMetaTableAccessor.scanMeta(metaTable, tableName, MetaTableAccessor.QueryType.REGION, visitor), (v, error) -> {
            if (error != null) {
                future.completeExceptionally((Throwable)error);
                return;
            }
            future.complete(visitor.getResults());
        });
        return future;
    }

    private static CompletableFuture<Void> scanMeta(AsyncTable<AdvancedScanResultConsumer> metaTable, TableName tableName, MetaTableAccessor.QueryType type, MetaTableAccessor.Visitor visitor) {
        return AsyncMetaTableAccessor.scanMeta(metaTable, AsyncMetaTableAccessor.getTableStartRowForMeta(tableName, type), AsyncMetaTableAccessor.getTableStopRowForMeta(tableName, type), type, Integer.MAX_VALUE, visitor);
    }

    private static CompletableFuture<Void> scanMeta(AsyncTable<AdvancedScanResultConsumer> metaTable, byte[] startRow, byte[] stopRow, MetaTableAccessor.QueryType type, int maxRows, MetaTableAccessor.Visitor visitor) {
        int rowUpperLimit = maxRows > 0 ? maxRows : Integer.MAX_VALUE;
        Scan scan = AsyncMetaTableAccessor.getMetaScan(metaTable, rowUpperLimit);
        for (byte[] family : type.getFamilies()) {
            scan.addFamily(family);
        }
        if (startRow != null) {
            scan.withStartRow(startRow);
        }
        if (stopRow != null) {
            scan.withStopRow(stopRow);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanning META starting at row=" + Bytes.toStringBinary(scan.getStartRow()) + " stopping at row=" + Bytes.toStringBinary(scan.getStopRow()) + " for max=" + rowUpperLimit + " with caching=" + scan.getCaching());
        }
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        metaTable.scan(scan, new MetaTableScanResultConsumer(rowUpperLimit, visitor, future));
        return future;
    }

    private static Scan getMetaScan(AsyncTable<?> metaTable, int rowUpperLimit) {
        Scan scan = new Scan();
        int scannerCaching = metaTable.getConfiguration().getInt("hbase.meta.scanner.caching", 100);
        if (metaTable.getConfiguration().getBoolean("hbase.meta.replicas.use", false)) {
            scan.setConsistency(Consistency.TIMELINE);
        }
        if (rowUpperLimit <= scannerCaching) {
            scan.setLimit(rowUpperLimit);
        }
        int rows = Math.min(rowUpperLimit, scannerCaching);
        scan.setCaching(rows);
        return scan;
    }

    private static Optional<RegionLocations> getRegionLocations(Result r) {
        Map.Entry entry;
        if (r == null) {
            return Optional.empty();
        }
        Optional<RegionInfo> regionInfo = AsyncMetaTableAccessor.getHRegionInfo(r, AsyncMetaTableAccessor.getRegionInfoColumn());
        if (!regionInfo.isPresent()) {
            return Optional.empty();
        }
        ArrayList<HRegionLocation> locations = new ArrayList<HRegionLocation>(1);
        NavigableMap<byte[], NavigableMap<byte[], byte[]>> familyMap = r.getNoVersionMap();
        locations.add(AsyncMetaTableAccessor.getRegionLocation(r, regionInfo.get(), 0));
        NavigableMap infoMap = (NavigableMap)familyMap.get(AsyncMetaTableAccessor.getCatalogFamily());
        if (infoMap == null) {
            return Optional.of(new RegionLocations(locations));
        }
        int replicaId = 0;
        byte[] serverColumn = AsyncMetaTableAccessor.getServerColumn(replicaId);
        NavigableMap serverMap = null;
        serverMap = infoMap.tailMap(serverColumn, false);
        if (serverMap.isEmpty()) {
            return Optional.of(new RegionLocations(locations));
        }
        Iterator iterator2 = serverMap.entrySet().iterator();
        while (iterator2.hasNext() && (replicaId = AsyncMetaTableAccessor.parseReplicaIdFromServerColumn((byte[])(entry = iterator2.next()).getKey())) >= 0) {
            HRegionLocation location = AsyncMetaTableAccessor.getRegionLocation(r, regionInfo.get(), replicaId);
            if (location == null || location.getServerName() == null) {
                locations.add(null);
                continue;
            }
            locations.add(location);
        }
        return Optional.of(new RegionLocations(locations));
    }

    private static HRegionLocation getRegionLocation(Result r, RegionInfo regionInfo, int replicaId) {
        Optional<ServerName> serverName = AsyncMetaTableAccessor.getServerName(r, replicaId);
        long seqNum = AsyncMetaTableAccessor.getSeqNumDuringOpen(r, replicaId);
        RegionInfo replicaInfo = RegionReplicaUtil.getRegionInfoForReplica(regionInfo, replicaId);
        return new HRegionLocation(replicaInfo, serverName.orElse(null), seqNum);
    }

    private static Optional<ServerName> getServerName(Result r, int replicaId) {
        byte[] serverColumn = AsyncMetaTableAccessor.getServerColumn(replicaId);
        Cell cell = r.getColumnLatestCell(AsyncMetaTableAccessor.getCatalogFamily(), serverColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return Optional.empty();
        }
        String hostAndPort = Bytes.toString(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
        byte[] startcodeColumn = AsyncMetaTableAccessor.getStartCodeColumn(replicaId);
        cell = r.getColumnLatestCell(AsyncMetaTableAccessor.getCatalogFamily(), startcodeColumn);
        if (cell == null || cell.getValueLength() == 0) {
            return Optional.empty();
        }
        try {
            return Optional.of(ServerName.valueOf(hostAndPort, Bytes.toLong(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength())));
        }
        catch (IllegalArgumentException e) {
            LOG.error("Ignoring invalid region for server " + hostAndPort + "; cell=" + cell, (Throwable)e);
            return Optional.empty();
        }
    }

    private static long getSeqNumDuringOpen(Result r, int replicaId) {
        Cell cell = r.getColumnLatestCell(AsyncMetaTableAccessor.getCatalogFamily(), AsyncMetaTableAccessor.getSeqNumColumn(replicaId));
        if (cell == null || cell.getValueLength() == 0) {
            return -1L;
        }
        return Bytes.toLong(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength());
    }

    private static byte[] getTableStartRowForMeta(TableName tableName, MetaTableAccessor.QueryType type) {
        if (tableName == null) {
            return null;
        }
        switch (type) {
            case REGION: 
            case REPLICATION: {
                byte[] startRow = new byte[tableName.getName().length + 2];
                System.arraycopy(tableName.getName(), 0, startRow, 0, tableName.getName().length);
                startRow[startRow.length - 2] = 44;
                startRow[startRow.length - 1] = 44;
                return startRow;
            }
        }
        return tableName.getName();
    }

    private static byte[] getTableStopRowForMeta(TableName tableName, MetaTableAccessor.QueryType type) {
        byte[] stopRow;
        if (tableName == null) {
            return null;
        }
        switch (type) {
            case REGION: 
            case REPLICATION: {
                stopRow = new byte[tableName.getName().length + 3];
                System.arraycopy(tableName.getName(), 0, stopRow, 0, tableName.getName().length);
                stopRow[stopRow.length - 3] = 32;
                stopRow[stopRow.length - 2] = 44;
                stopRow[stopRow.length - 1] = 44;
                break;
            }
            default: {
                stopRow = new byte[tableName.getName().length + 1];
                System.arraycopy(tableName.getName(), 0, stopRow, 0, tableName.getName().length);
                stopRow[stopRow.length - 1] = 32;
            }
        }
        return stopRow;
    }

    private static Optional<RegionInfo> getHRegionInfo(Result r, byte[] qualifier) {
        Cell cell = r.getColumnLatestCell(AsyncMetaTableAccessor.getCatalogFamily(), qualifier);
        if (cell == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(RegionInfo.parseFromOrNull(cell.getValueArray(), cell.getValueOffset(), cell.getValueLength()));
    }

    private static byte[] getCatalogFamily() {
        return HConstants.CATALOG_FAMILY;
    }

    private static byte[] getTableFamily() {
        return HConstants.TABLE_FAMILY;
    }

    private static byte[] getRegionInfoColumn() {
        return HConstants.REGIONINFO_QUALIFIER;
    }

    private static byte[] getStateColumn() {
        return HConstants.TABLE_STATE_QUALIFIER;
    }

    private static byte[] getServerColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SERVER_QUALIFIER : Bytes.toBytes("server_" + String.format("%04X", replicaId));
    }

    private static byte[] getStartCodeColumn(int replicaId) {
        return replicaId == 0 ? HConstants.STARTCODE_QUALIFIER : Bytes.toBytes("serverstartcode_" + String.format("%04X", replicaId));
    }

    private static byte[] getSeqNumColumn(int replicaId) {
        return replicaId == 0 ? HConstants.SEQNUM_QUALIFIER : Bytes.toBytes("seqnumDuringOpen_" + String.format("%04X", replicaId));
    }

    private static int parseReplicaIdFromServerColumn(byte[] serverColumn) {
        String serverStr = Bytes.toString(serverColumn);
        Matcher matcher = SERVER_COLUMN_PATTERN.matcher(serverStr);
        if (matcher.matches() && matcher.groupCount() > 0) {
            String group = matcher.group(1);
            if (group != null && group.length() > 0) {
                return Integer.parseInt(group.substring(1), 16);
            }
            return 0;
        }
        return -1;
    }

    private static final class MetaTableScanResultConsumer
    implements AdvancedScanResultConsumer {
        private int currentRowCount;
        private final int rowUpperLimit;
        private final MetaTableAccessor.Visitor visitor;
        private final CompletableFuture<Void> future;

        MetaTableScanResultConsumer(int rowUpperLimit, MetaTableAccessor.Visitor visitor, CompletableFuture<Void> future) {
            this.rowUpperLimit = rowUpperLimit;
            this.visitor = visitor;
            this.future = future;
            this.currentRowCount = 0;
        }

        @Override
        public void onError(Throwable error) {
            this.future.completeExceptionally(error);
        }

        @Override
        @SuppressWarnings(value={"NP_NONNULL_PARAM_VIOLATION"}, justification="https://github.com/findbugsproject/findbugs/issues/79")
        public void onComplete() {
            this.future.complete(null);
        }

        @Override
        public void onNext(Result[] results, AdvancedScanResultConsumer.ScanController controller) {
            boolean terminateScan = false;
            for (Result result : results) {
                block5: {
                    try {
                        if (!this.visitor.visit(result)) {
                            terminateScan = true;
                        }
                        break block5;
                    }
                    catch (Exception e) {
                        this.future.completeExceptionally(e);
                        terminateScan = true;
                    }
                    break;
                }
                if (++this.currentRowCount < this.rowUpperLimit) continue;
                terminateScan = true;
                break;
            }
            if (terminateScan) {
                controller.terminate();
            }
        }
    }
}

