/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase;

import io.hops.hudi.org.apache.hadoop.hbase.CacheEvictionStatsBuilder;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Public
public final class CacheEvictionStats {
    private final long evictedBlocks;
    private final long maxCacheSize;
    private final Map<byte[], Throwable> exceptions;

    CacheEvictionStats(CacheEvictionStatsBuilder builder) {
        this.evictedBlocks = builder.evictedBlocks;
        this.maxCacheSize = builder.maxCacheSize;
        this.exceptions = builder.exceptions;
    }

    public long getEvictedBlocks() {
        return this.evictedBlocks;
    }

    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public Map<byte[], Throwable> getExceptions() {
        return Collections.unmodifiableMap(this.exceptions);
    }

    public int getExceptionCount() {
        return this.exceptions.size();
    }

    private String getFailedRegions() {
        return this.exceptions.keySet().stream().map(regionName -> RegionInfo.prettyPrint(RegionInfo.encodeRegionName(regionName))).collect(Collectors.toList()).toString();
    }

    @InterfaceAudience.Private
    public static CacheEvictionStatsBuilder builder() {
        return new CacheEvictionStatsBuilder();
    }

    public String toString() {
        return "CacheEvictionStats{evictedBlocks=" + this.evictedBlocks + ", maxCacheSize=" + this.maxCacheSize + ", failedRegionsSize=" + this.getExceptionCount() + ", failedRegions=" + this.getFailedRegions() + '}';
    }
}

