/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase;

import io.hops.hudi.org.apache.hadoop.hbase.ByteBufferKeyValue;
import io.hops.hudi.org.apache.hadoop.hbase.ExtendedCell;
import io.hops.hudi.org.apache.hadoop.hbase.HConstants;
import io.hops.hudi.org.apache.hadoop.hbase.NoTagsKeyValue;
import io.hops.hudi.org.apache.hadoop.hbase.util.ByteBufferUtils;
import java.nio.ByteBuffer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NoTagsByteBufferKeyValue
extends ByteBufferKeyValue {
    public NoTagsByteBufferKeyValue(ByteBuffer buf, int offset, int length) {
        super(buf, offset, length);
    }

    public NoTagsByteBufferKeyValue(ByteBuffer buf, int offset, int length, long seqId) {
        super(buf, offset, length, seqId);
    }

    @Override
    public byte[] getTagsArray() {
        return HConstants.EMPTY_BYTE_ARRAY;
    }

    @Override
    public int getTagsLength() {
        return 0;
    }

    @Override
    public int getSerializedSize(boolean withTags) {
        return this.length;
    }

    @Override
    public ExtendedCell deepClone() {
        byte[] copy = new byte[this.length];
        ByteBufferUtils.copyFromBufferToArray(copy, this.buf, this.offset, 0, this.length);
        NoTagsKeyValue kv = new NoTagsKeyValue(copy, 0, copy.length);
        kv.setSequenceId(this.getSequenceId());
        return kv;
    }
}

