/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase;

import io.hops.hudi.org.apache.hadoop.hbase.ByteBufferKeyValue;
import java.nio.ByteBuffer;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SizeCachedByteBufferKeyValue
extends ByteBufferKeyValue {
    public static final int FIXED_OVERHEAD = 6;
    private short rowLen;
    private int keyLen;

    public SizeCachedByteBufferKeyValue(ByteBuffer buf, int offset, int length, long seqId, int keyLen) {
        super(buf, offset, length);
        this.rowLen = super.getRowLength();
        this.keyLen = keyLen;
        this.setSequenceId(seqId);
    }

    public SizeCachedByteBufferKeyValue(ByteBuffer buf, int offset, int length, long seqId, int keyLen, short rowLen) {
        super(buf, offset, length);
        this.rowLen = rowLen;
        this.keyLen = keyLen;
        this.setSequenceId(seqId);
    }

    @Override
    public short getRowLength() {
        return this.rowLen;
    }

    @Override
    public int getKeyLength() {
        return this.keyLen;
    }

    @Override
    public long heapSize() {
        return super.heapSize() + 6L;
    }

    @Override
    public int getSerializedSize() {
        return this.length;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

