/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.client;

import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.AsyncConnectionConfiguration;
import io.hops.hudi.org.apache.hadoop.hbase.client.AsyncTableBuilder;
import io.hops.hudi.org.apache.hadoop.hbase.client.ConnectionUtils;
import io.hops.hudi.org.apache.hadoop.hbase.client.ScanResultConsumerBase;
import java.util.concurrent.TimeUnit;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
abstract class AsyncTableBuilderBase<C extends ScanResultConsumerBase>
implements AsyncTableBuilder<C> {
    protected TableName tableName;
    protected long operationTimeoutNs;
    protected long scanTimeoutNs;
    protected long rpcTimeoutNs;
    protected long readRpcTimeoutNs;
    protected long writeRpcTimeoutNs;
    protected long pauseNs;
    protected long pauseForCQTBENs;
    protected int maxAttempts;
    protected int startLogErrorsCnt;

    AsyncTableBuilderBase(TableName tableName, AsyncConnectionConfiguration connConf) {
        this.tableName = tableName;
        this.operationTimeoutNs = tableName.isSystemTable() ? connConf.getMetaOperationTimeoutNs() : connConf.getOperationTimeoutNs();
        this.scanTimeoutNs = connConf.getScanTimeoutNs();
        this.rpcTimeoutNs = connConf.getRpcTimeoutNs();
        this.readRpcTimeoutNs = connConf.getReadRpcTimeoutNs();
        this.writeRpcTimeoutNs = connConf.getWriteRpcTimeoutNs();
        this.pauseNs = connConf.getPauseNs();
        this.pauseForCQTBENs = connConf.getPauseForCQTBENs();
        this.maxAttempts = ConnectionUtils.retries2Attempts(connConf.getMaxRetries());
        this.startLogErrorsCnt = connConf.getStartLogErrorsCnt();
    }

    @Override
    public AsyncTableBuilderBase<C> setOperationTimeout(long timeout, TimeUnit unit) {
        this.operationTimeoutNs = unit.toNanos(timeout);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<C> setScanTimeout(long timeout, TimeUnit unit) {
        this.scanTimeoutNs = unit.toNanos(timeout);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<C> setRpcTimeout(long timeout, TimeUnit unit) {
        this.rpcTimeoutNs = unit.toNanos(timeout);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<C> setReadRpcTimeout(long timeout, TimeUnit unit) {
        this.readRpcTimeoutNs = unit.toNanos(timeout);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<C> setWriteRpcTimeout(long timeout, TimeUnit unit) {
        this.writeRpcTimeoutNs = unit.toNanos(timeout);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<C> setRetryPause(long pause, TimeUnit unit) {
        this.pauseNs = unit.toNanos(pause);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<C> setRetryPauseForCQTBE(long pause, TimeUnit unit) {
        this.pauseForCQTBENs = unit.toNanos(pause);
        return this;
    }

    @Override
    public AsyncTableBuilderBase<C> setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

    @Override
    public AsyncTableBuilderBase<C> setStartLogErrorsCnt(int startLogErrorsCnt) {
        this.startLogErrorsCnt = startLogErrorsCnt;
        return this;
    }
}

