/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.io.hfile.bucket;

import io.hops.hudi.org.apache.hadoop.hbase.io.ByteBuffAllocator;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.BlockPriority;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.Cacheable;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import io.hops.hudi.org.apache.hadoop.hbase.io.hfile.CacheableDeserializerIdManager;
import io.hops.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import io.hops.hudi.org.apache.hadoop.hbase.nio.HBaseReferenceCounted;
import io.hops.hudi.org.apache.hadoop.hbase.nio.RefCnt;
import io.hops.hudi.org.apache.hadoop.hbase.util.IdReadWriteLock;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class BucketEntry
implements HBaseReferenceCounted {
    static final Comparator<BucketEntry> COMPARATOR = Comparator.comparingLong(BucketEntry::getAccessCounter).reversed();
    private int offsetBase;
    private int length;
    private byte offset1;
    byte deserializerIndex;
    private volatile long accessCounter;
    private BlockPriority priority;
    private final RefCnt refCnt;
    final AtomicBoolean markedAsEvicted;
    final ByteBuffAllocator allocator;
    private final long cachedTime = System.nanoTime();

    BucketEntry(long offset, int length, long accessCounter, boolean inMemory, Function<BucketEntry, ByteBuffAllocator.Recycler> createRecycler, ByteBuffAllocator allocator) {
        if (createRecycler == null) {
            throw new IllegalArgumentException("createRecycler could not be null!");
        }
        this.setOffset(offset);
        this.length = length;
        this.accessCounter = accessCounter;
        this.priority = inMemory ? BlockPriority.MEMORY : BlockPriority.MULTI;
        this.refCnt = RefCnt.create(createRecycler.apply(this));
        this.markedAsEvicted = new AtomicBoolean(false);
        this.allocator = allocator;
    }

    long offset() {
        long o = (long)this.offsetBase & 0xFFFFFFFFL;
        return (o += ((long)this.offset1 & 0xFFL) << 32) << 8;
    }

    private void setOffset(long value) {
        assert ((value & 0xFFL) == 0L);
        this.offsetBase = (int)(value >>= 8);
        this.offset1 = (byte)(value >> 32);
    }

    public int getLength() {
        return this.length;
    }

    CacheableDeserializer<Cacheable> deserializerReference() {
        return CacheableDeserializerIdManager.getDeserializer(this.deserializerIndex);
    }

    void setDeserializerReference(CacheableDeserializer<Cacheable> deserializer) {
        this.deserializerIndex = (byte)deserializer.getDeserializerIdentifier();
    }

    long getAccessCounter() {
        return this.accessCounter;
    }

    void access(long accessCounter) {
        this.accessCounter = accessCounter;
        if (this.priority == BlockPriority.SINGLE) {
            this.priority = BlockPriority.MULTI;
        }
    }

    public BlockPriority getPriority() {
        return this.priority;
    }

    long getCachedTime() {
        return this.cachedTime;
    }

    boolean markAsEvicted() {
        if (this.markedAsEvicted.compareAndSet(false, true)) {
            return this.release();
        }
        return false;
    }

    boolean isRpcRef() {
        boolean evicted = this.markedAsEvicted.get();
        return this.refCnt() > 1 || evicted && this.refCnt() == 1;
    }

    Cacheable wrapAsCacheable(ByteBuffer[] buffers) throws IOException {
        return this.wrapAsCacheable(ByteBuff.wrap(buffers, this.refCnt));
    }

    Cacheable wrapAsCacheable(ByteBuff buf) throws IOException {
        return this.deserializerReference().deserialize(buf, this.allocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T withWriteLock(IdReadWriteLock<Long> offsetLock, BucketEntryHandler<T> handler) {
        ReentrantReadWriteLock lock = offsetLock.getLock(this.offset());
        try {
            lock.writeLock().lock();
            T t = handler.handle();
            return t;
        }
        finally {
            lock.writeLock().unlock();
        }
    }

    @Override
    public int refCnt() {
        return this.refCnt.refCnt();
    }

    @Override
    public BucketEntry retain() {
        this.refCnt.retain();
        return this;
    }

    @Override
    public boolean release() {
        return this.refCnt.release();
    }

    static interface BucketEntryHandler<T> {
        public T handle();
    }
}

