/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.ipc;

import io.hops.hudi.org.apache.hadoop.hbase.client.MetricsConnection;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.AbstractRpcClient;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.ConnectionId;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.NettyRpcClientConfigHelper;
import io.hops.hudi.org.apache.hadoop.hbase.ipc.NettyRpcConnection;
import io.hops.hudi.org.apache.hadoop.hbase.util.Pair;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.Channel;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.EventLoopGroup;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.nio.NioEventLoopGroup;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.channel.socket.nio.NioSocketChannel;
import io.hops.hudi.org.apache.hbase.thirdparty.io.netty.util.concurrent.DefaultThreadFactory;
import java.io.IOException;
import java.net.SocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class NettyRpcClient
extends AbstractRpcClient<NettyRpcConnection> {
    final EventLoopGroup group;
    final Class<? extends Channel> channelClass;
    private final boolean shutdownGroupWhenClose;

    public NettyRpcClient(Configuration configuration, String clusterId, SocketAddress localAddress, MetricsConnection metrics) {
        super(configuration, clusterId, localAddress, metrics);
        Pair<EventLoopGroup, Class<? extends Channel>> groupAndChannelClass = NettyRpcClientConfigHelper.getEventLoopConfig(this.conf);
        if (groupAndChannelClass == null) {
            int threadCount = this.conf.getInt("hbase.netty.eventloop.rpcclient.thread.count", 0);
            this.group = new NioEventLoopGroup(threadCount, new DefaultThreadFactory("RPCClient(own)-NioEventLoopGroup", true, 5));
            this.channelClass = NioSocketChannel.class;
            this.shutdownGroupWhenClose = true;
        } else {
            this.group = groupAndChannelClass.getFirst();
            this.channelClass = groupAndChannelClass.getSecond();
            this.shutdownGroupWhenClose = false;
        }
    }

    NettyRpcClient(Configuration configuration) {
        this(configuration, "default-cluster", null, null);
    }

    @Override
    protected NettyRpcConnection createConnection(ConnectionId remoteId) throws IOException {
        return new NettyRpcConnection(this, remoteId);
    }

    @Override
    protected void closeInternal() {
        if (this.shutdownGroupWhenClose) {
            this.group.shutdownGracefully();
        }
    }
}

