/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master;

import io.hops.hudi.org.apache.hadoop.hbase.ClusterId;
import io.hops.hudi.org.apache.hadoop.hbase.Server;
import io.hops.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import io.hops.hudi.org.apache.hadoop.hbase.util.FSUtils;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class CachedClusterId {
    public static final Logger LOG = LoggerFactory.getLogger(CachedClusterId.class);
    private static final int MAX_FETCH_TIMEOUT_MS = 10000;
    private final Path rootDir;
    private final FileSystem fs;
    AtomicBoolean fetchInProgress = new AtomicBoolean(false);
    private AtomicBoolean isClusterIdSet = new AtomicBoolean(false);
    private ClusterId clusterId;
    private final Server server;
    private AtomicInteger cacheMisses = new AtomicInteger(0);

    public CachedClusterId(Server server, Configuration conf) throws IOException {
        this.rootDir = CommonFSUtils.getRootDir(conf);
        this.fs = this.rootDir.getFileSystem(conf);
        this.server = server;
    }

    private void setClusterId(ClusterId id) {
        if (id == null || this.isClusterIdSet.get()) {
            return;
        }
        this.clusterId = id;
        this.isClusterIdSet.set(true);
    }

    private String getClusterId() {
        if (!this.isClusterIdSet.get()) {
            return null;
        }
        return this.clusterId.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attemptFetch() {
        if (this.fetchInProgress.compareAndSet(false, true)) {
            try {
                this.cacheMisses.incrementAndGet();
                this.setClusterId(FSUtils.getClusterId(this.fs, this.rootDir));
            }
            catch (IOException e) {
                LOG.warn("Error fetching cluster ID", (Throwable)e);
            }
            finally {
                Preconditions.checkState(this.fetchInProgress.compareAndSet(true, false));
                AtomicBoolean atomicBoolean = this.fetchInProgress;
                synchronized (atomicBoolean) {
                    this.fetchInProgress.notifyAll();
                }
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForFetchToFinish() throws InterruptedException {
        AtomicBoolean atomicBoolean = this.fetchInProgress;
        synchronized (atomicBoolean) {
            while (this.fetchInProgress.get()) {
                this.fetchInProgress.wait(10000L);
            }
        }
    }

    public String getFromCacheOrFetch() {
        if (this.server.isStopping() || this.server.isStopped()) {
            return null;
        }
        String id = this.getClusterId();
        if (id != null) {
            return id;
        }
        if (!this.attemptFetch()) {
            try {
                this.waitForFetchToFinish();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.getClusterId();
    }

    public int getCacheStats() {
        return this.cacheMisses.get();
    }
}

