/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master.procedure;

import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.ProcedurePrepareLatch;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.Procedure;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public abstract class AbstractStateMachineNamespaceProcedure<TState>
extends StateMachineProcedure<MasterProcedureEnv, TState>
implements TableProcedureInterface {
    private final ProcedurePrepareLatch syncLatch;

    protected AbstractStateMachineNamespaceProcedure() {
        this.syncLatch = null;
    }

    protected AbstractStateMachineNamespaceProcedure(MasterProcedureEnv env) {
        this(env, null);
    }

    protected AbstractStateMachineNamespaceProcedure(MasterProcedureEnv env, ProcedurePrepareLatch latch) {
        this.setOwner(env.getRequestUser());
        this.syncLatch = latch;
    }

    protected abstract String getNamespaceName();

    @Override
    public TableName getTableName() {
        return TableName.NAMESPACE_TABLE_NAME;
    }

    @Override
    public abstract TableProcedureInterface.TableOperationType getTableOperationType();

    public void toStringClassDetails(StringBuilder sb) {
        sb.append(this.getClass().getSimpleName());
        sb.append(", namespace=");
        sb.append(this.getNamespaceName());
    }

    protected boolean waitInitialized(MasterProcedureEnv env) {
        return env.waitInitialized((Procedure<?>)this);
    }

    protected Procedure.LockState acquireLock(MasterProcedureEnv env) {
        if (env.getProcedureScheduler().waitNamespaceExclusiveLock((Procedure<?>)this, this.getNamespaceName())) {
            return Procedure.LockState.LOCK_EVENT_WAIT;
        }
        return Procedure.LockState.LOCK_ACQUIRED;
    }

    protected void releaseLock(MasterProcedureEnv env) {
        env.getProcedureScheduler().wakeNamespaceExclusiveLock((Procedure<?>)this, this.getNamespaceName());
    }

    protected void releaseSyncLatch() {
        ProcedurePrepareLatch.releaseLatch(this.syncLatch, (Procedure)this);
    }
}

