/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master.procedure;

import io.hops.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.master.MasterServices;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.ServerProcedureInterface;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.Procedure;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.ProcedureException;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import io.hops.hudi.org.apache.hadoop.hbase.security.User;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.RPCProtos;
import io.hops.hudi.org.apache.hadoop.hbase.util.NonceKey;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public final class MasterProcedureUtil {
    @Deprecated
    private static final Pattern PATTERN = Pattern.compile(".*pv2-\\d{20}.log");

    private MasterProcedureUtil() {
    }

    public static RPCProtos.UserInformation toProtoUserInfo(User user) {
        RPCProtos.UserInformation.Builder userInfoPB = RPCProtos.UserInformation.newBuilder();
        userInfoPB.setEffectiveUser(user.getName());
        if (user.getUGI().getRealUser() != null) {
            userInfoPB.setRealUser(user.getUGI().getRealUser().getUserName());
        }
        return userInfoPB.build();
    }

    public static User toUserInfo(RPCProtos.UserInformation userInfoProto) {
        if (userInfoProto.hasEffectiveUser()) {
            String effectiveUser = userInfoProto.getEffectiveUser();
            if (userInfoProto.hasRealUser()) {
                String realUser = userInfoProto.getRealUser();
                UserGroupInformation realUserUgi = UserGroupInformation.createRemoteUser((String)realUser);
                return User.create(UserGroupInformation.createProxyUser((String)effectiveUser, (UserGroupInformation)realUserUgi));
            }
            return User.create(UserGroupInformation.createRemoteUser((String)effectiveUser));
        }
        return null;
    }

    public static long submitProcedure(NonceProcedureRunnable runnable) throws IOException {
        ProcedureExecutor<MasterProcedureEnv> procExec = runnable.getProcedureExecutor();
        long procId = procExec.registerNonce(runnable.getNonceKey());
        if (procId >= 0L) {
            return procId;
        }
        try {
            runnable.run();
        }
        catch (IOException e) {
            procExec.setFailureResultForNonce(runnable.getNonceKey(), runnable.getDescription(), ((MasterProcedureEnv)procExec.getEnvironment()).getRequestUser(), e);
            throw e;
        }
        finally {
            procExec.unregisterNonceIfProcedureWasNotSubmitted(runnable.getNonceKey());
        }
        return runnable.getProcId();
    }

    public static boolean validateProcedureWALFilename(String filename) {
        return PATTERN.matcher(filename).matches();
    }

    public static int getTablePriority(TableName tableName) {
        if (TableName.isMetaTableName(tableName)) {
            return 3;
        }
        if (tableName.isSystemTable()) {
            return 2;
        }
        return 1;
    }

    public static int getServerPriority(ServerProcedureInterface proc) {
        return proc.hasMetaTableRegion() ? 100 : 1;
    }

    public static IOException unwrapRemoteIOException(Procedure proc) {
        Exception e = proc.getException().unwrapRemoteException();
        return e instanceof ProcedureException ? new DoNotRetryIOException(e) : proc.getException().unwrapRemoteIOException();
    }

    public static abstract class NonceProcedureRunnable {
        private final MasterServices master;
        private final NonceKey nonceKey;
        private Long procId;

        public NonceProcedureRunnable(MasterServices master, long nonceGroup, long nonce) {
            this.master = master;
            this.nonceKey = this.getProcedureExecutor().createNonceKey(nonceGroup, nonce);
        }

        protected NonceKey getNonceKey() {
            return this.nonceKey;
        }

        protected MasterServices getMaster() {
            return this.master;
        }

        protected ProcedureExecutor<MasterProcedureEnv> getProcedureExecutor() {
            return this.master.getMasterProcedureExecutor();
        }

        protected long getProcId() {
            return this.procId != null ? this.procId : -1L;
        }

        protected long setProcId(long procId) {
            this.procId = procId;
            return procId;
        }

        protected abstract void run() throws IOException;

        protected abstract String getDescription();

        protected long submitProcedure(Procedure<MasterProcedureEnv> proc) {
            assert (this.procId == null) : "submitProcedure() was already called, running procId=" + this.procId;
            this.procId = this.getProcedureExecutor().submitProcedure(proc, this.nonceKey);
            return this.procId;
        }
    }
}

