/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.master.replication;

import io.hops.hudi.org.apache.hadoop.hbase.MetaTableAccessor;
import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.Connection;
import io.hops.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import io.hops.hudi.org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import io.hops.hudi.org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import io.hops.hudi.org.apache.hadoop.hbase.master.procedure.PeerProcedureInterface;
import io.hops.hudi.org.apache.hadoop.hbase.master.replication.ModifyPeerProcedure;
import io.hops.hudi.org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import io.hops.hudi.org.apache.hadoop.hbase.replication.ReplicationException;
import io.hops.hudi.org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import io.hops.hudi.org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import io.hops.hudi.org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import io.hops.hudi.org.apache.hadoop.hbase.replication.ReplicationUtils;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class UpdatePeerConfigProcedure
extends ModifyPeerProcedure {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatePeerConfigProcedure.class);
    private ReplicationPeerConfig peerConfig;
    private ReplicationPeerConfig oldPeerConfig;
    private boolean enabled;

    public UpdatePeerConfigProcedure() {
    }

    public UpdatePeerConfigProcedure(String peerId, ReplicationPeerConfig peerConfig) {
        super(peerId);
        this.peerConfig = peerConfig;
    }

    @Override
    public PeerProcedureInterface.PeerOperationType getPeerOperationType() {
        return PeerProcedureInterface.PeerOperationType.UPDATE_CONFIG;
    }

    private void addToList(List<String> encodedRegionNames, String encodedRegionName, ReplicationQueueStorage queueStorage) throws ReplicationException {
        encodedRegionNames.add(encodedRegionName);
        if (encodedRegionNames.size() >= 1000) {
            queueStorage.removeLastSequenceIds(this.peerId, encodedRegionNames);
            encodedRegionNames.clear();
        }
    }

    @Override
    protected MasterProcedureProtos.PeerModificationState nextStateAfterRefresh() {
        if (this.peerConfig.isSerial()) {
            if (this.oldPeerConfig.isSerial()) {
                return ReplicationUtils.isNamespacesAndTableCFsEqual((ReplicationPeerConfig)this.peerConfig, (ReplicationPeerConfig)this.oldPeerConfig) ? super.nextStateAfterRefresh() : MasterProcedureProtos.PeerModificationState.SERIAL_PEER_REOPEN_REGIONS;
            }
            return MasterProcedureProtos.PeerModificationState.SERIAL_PEER_REOPEN_REGIONS;
        }
        if (this.oldPeerConfig.isSerial()) {
            return MasterProcedureProtos.PeerModificationState.SERIAL_PEER_UPDATE_LAST_PUSHED_SEQ_ID;
        }
        return super.nextStateAfterRefresh();
    }

    @Override
    protected void updateLastPushedSequenceIdForSerialPeer(MasterProcedureEnv env) throws IOException, ReplicationException {
        if (!this.oldPeerConfig.isSerial()) {
            assert (this.peerConfig.isSerial());
            this.setLastPushedSequenceId(env, this.peerConfig);
            return;
        }
        if (!this.peerConfig.isSerial()) {
            env.getReplicationPeerManager().removeAllLastPushedSeqIds(this.peerId);
            return;
        }
        ReplicationQueueStorage queueStorage = env.getReplicationPeerManager().getQueueStorage();
        Connection conn = env.getMasterServices().getConnection();
        HashMap<String, Long> lastSeqIds = new HashMap<String, Long>();
        ArrayList<String> encodedRegionNames = new ArrayList<String>();
        for (TableDescriptor td : env.getMasterServices().getTableDescriptors().getAll().values()) {
            if (!td.hasGlobalReplicationScope()) continue;
            TableName tn = td.getTableName();
            if (this.oldPeerConfig.needToReplicate(tn)) {
                if (this.peerConfig.needToReplicate(tn)) continue;
                for (String encodedRegionName : MetaTableAccessor.getTableEncodedRegionNamesForSerialReplication(conn, tn)) {
                    this.addToList(encodedRegionNames, encodedRegionName, queueStorage);
                }
                continue;
            }
            if (!this.peerConfig.needToReplicate(tn)) continue;
            this.setLastPushedSequenceIdForTable(env, tn, lastSeqIds);
        }
        if (!encodedRegionNames.isEmpty()) {
            queueStorage.removeLastSequenceIds(this.peerId, encodedRegionNames);
        }
        if (!lastSeqIds.isEmpty()) {
            queueStorage.setLastSequenceIds(this.peerId, lastSeqIds);
        }
    }

    @Override
    protected boolean enablePeerBeforeFinish() {
        return this.enabled;
    }

    @Override
    protected ReplicationPeerConfig getOldPeerConfig() {
        return this.oldPeerConfig;
    }

    @Override
    protected ReplicationPeerConfig getNewPeerConfig() {
        return this.peerConfig;
    }

    @Override
    protected void prePeerModification(MasterProcedureEnv env) throws IOException {
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.preUpdateReplicationPeerConfig(this.peerId, this.peerConfig);
        }
        ReplicationPeerDescription desc = env.getReplicationPeerManager().preUpdatePeerConfig(this.peerId, this.peerConfig);
        this.oldPeerConfig = desc.getPeerConfig();
        this.enabled = desc.isEnabled();
    }

    @Override
    protected void updatePeerStorage(MasterProcedureEnv env) throws ReplicationException {
        env.getReplicationPeerManager().updatePeerConfig(this.peerId, this.peerConfig);
        if (this.enabled && this.nextStateAfterRefresh() != super.nextStateAfterRefresh()) {
            env.getReplicationPeerManager().disablePeer(this.peerId);
        }
    }

    @Override
    protected void postPeerModification(MasterProcedureEnv env) throws IOException, ReplicationException {
        if (this.oldPeerConfig.isSerial() && !this.peerConfig.isSerial()) {
            env.getReplicationPeerManager().removeAllLastPushedSeqIds(this.peerId);
        }
        LOG.info("Successfully updated peer config of {} to {}", (Object)this.peerId, (Object)this.peerConfig);
        MasterCoprocessorHost cpHost = env.getMasterCoprocessorHost();
        if (cpHost != null) {
            cpHost.postUpdateReplicationPeerConfig(this.peerId, this.peerConfig);
        }
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.UpdatePeerConfigStateData.Builder builder = MasterProcedureProtos.UpdatePeerConfigStateData.newBuilder().setPeerConfig(ReplicationPeerConfigUtil.convert(this.peerConfig));
        if (this.oldPeerConfig != null) {
            builder.setOldPeerConfig(ReplicationPeerConfigUtil.convert(this.oldPeerConfig));
        }
        builder.setEnabled(this.enabled);
        serializer.serialize((Message)builder.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.UpdatePeerConfigStateData data = (MasterProcedureProtos.UpdatePeerConfigStateData)serializer.deserialize(MasterProcedureProtos.UpdatePeerConfigStateData.class);
        this.peerConfig = ReplicationPeerConfigUtil.convert(data.getPeerConfig());
        this.oldPeerConfig = data.hasOldPeerConfig() ? ReplicationPeerConfigUtil.convert(data.getOldPeerConfig()) : null;
        this.enabled = data.getEnabled();
    }
}

