/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.quotas;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.NoopQuotaLimiter;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.QuotaLimiter;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.QuotaLimiterFactory;
import io.hops.hudi.org.apache.hadoop.hbase.quotas.QuotaState;
import io.hops.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import io.hops.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;

@InterfaceAudience.Private
@InterfaceStability.Evolving
@SuppressWarnings(value={"IS2_INCONSISTENT_SYNC"}, justification="FindBugs seems confused; says bypassGlobals, namepaceLimiters, and tableLimiters are mostly synchronized...but to me it looks like they are totally synchronized")
public class UserQuotaState
extends QuotaState {
    private Map<String, QuotaLimiter> namespaceLimiters = null;
    private Map<TableName, QuotaLimiter> tableLimiters = null;
    private boolean bypassGlobals = false;

    public UserQuotaState() {
    }

    public UserQuotaState(long updateTs) {
        super(updateTs);
    }

    @Override
    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("UserQuotaState(ts=" + this.getLastUpdate());
        if (this.bypassGlobals) {
            builder.append(" bypass-globals");
        }
        if (this.isBypass()) {
            builder.append(" bypass");
        } else {
            if (this.getGlobalLimiterWithoutUpdatingLastQuery() != NoopQuotaLimiter.get()) {
                builder.append(" global-limiter");
            }
            if (this.tableLimiters != null && !this.tableLimiters.isEmpty()) {
                builder.append(" [");
                for (TableName table : this.tableLimiters.keySet()) {
                    builder.append(" " + table);
                }
                builder.append(" ]");
            }
            if (this.namespaceLimiters != null && !this.namespaceLimiters.isEmpty()) {
                builder.append(" [");
                for (String ns : this.namespaceLimiters.keySet()) {
                    builder.append(" " + ns);
                }
                builder.append(" ]");
            }
        }
        builder.append(')');
        return builder.toString();
    }

    @Override
    public synchronized boolean isBypass() {
        return !(this.bypassGlobals || this.getGlobalLimiterWithoutUpdatingLastQuery() != NoopQuotaLimiter.get() || this.tableLimiters != null && !this.tableLimiters.isEmpty() || this.namespaceLimiters != null && !this.namespaceLimiters.isEmpty());
    }

    public synchronized boolean hasBypassGlobals() {
        return this.bypassGlobals;
    }

    @Override
    public synchronized void setQuotas(QuotaProtos.Quotas quotas) {
        super.setQuotas(quotas);
        this.bypassGlobals = quotas.getBypassGlobals();
    }

    public synchronized void setQuotas(TableName table, QuotaProtos.Quotas quotas) {
        this.tableLimiters = this.setLimiter(this.tableLimiters, table, quotas);
    }

    public void setQuotas(String namespace, QuotaProtos.Quotas quotas) {
        this.namespaceLimiters = this.setLimiter(this.namespaceLimiters, namespace, quotas);
    }

    private <K> Map<K, QuotaLimiter> setLimiter(Map<K, QuotaLimiter> limiters, K key, QuotaProtos.Quotas quotas) {
        QuotaLimiter limiter;
        if (limiters == null) {
            limiters = new HashMap<K, QuotaLimiter>();
        }
        QuotaLimiter quotaLimiter = limiter = quotas.hasThrottle() ? QuotaLimiterFactory.fromThrottle(quotas.getThrottle()) : null;
        if (limiter != null && !limiter.isBypass()) {
            limiters.put(key, limiter);
        } else {
            limiters.remove(key);
        }
        return limiters;
    }

    @Override
    public synchronized void update(QuotaState other) {
        super.update(other);
        if (other instanceof UserQuotaState) {
            UserQuotaState uOther = (UserQuotaState)other;
            this.tableLimiters = UserQuotaState.updateLimiters(this.tableLimiters, uOther.tableLimiters);
            this.namespaceLimiters = UserQuotaState.updateLimiters(this.namespaceLimiters, uOther.namespaceLimiters);
            this.bypassGlobals = uOther.bypassGlobals;
        } else {
            this.tableLimiters = null;
            this.namespaceLimiters = null;
            this.bypassGlobals = false;
        }
    }

    private static <K> Map<K, QuotaLimiter> updateLimiters(Map<K, QuotaLimiter> map, Map<K, QuotaLimiter> otherMap) {
        if (map == null) {
            return otherMap;
        }
        if (otherMap != null) {
            HashSet<K> toRemove = new HashSet<K>(map.keySet());
            toRemove.removeAll(otherMap.keySet());
            map.keySet().removeAll(toRemove);
            for (Map.Entry<K, QuotaLimiter> entry : otherMap.entrySet()) {
                QuotaLimiter limiter = map.get(entry.getKey());
                limiter = limiter == null ? entry.getValue() : QuotaLimiterFactory.update(limiter, entry.getValue());
                map.put(entry.getKey(), limiter);
            }
            return map;
        }
        return null;
    }

    public synchronized QuotaLimiter getTableLimiter(TableName table) {
        QuotaLimiter limiter;
        this.lastQuery = EnvironmentEdgeManager.currentTime();
        if (this.tableLimiters != null && (limiter = this.tableLimiters.get(table)) != null) {
            return limiter;
        }
        if (this.namespaceLimiters != null && (limiter = this.namespaceLimiters.get(table.getNamespaceAsString())) != null) {
            return limiter;
        }
        return this.getGlobalLimiterWithoutUpdatingLastQuery();
    }
}

