/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.replication.regionserver;

import io.hops.hudi.org.apache.hadoop.hbase.Cell;
import io.hops.hudi.org.apache.hadoop.hbase.replication.WALEntryFilter;
import io.hops.hudi.org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import io.hops.hudi.org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceLogQueue;
import io.hops.hudi.org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceWALReader;
import io.hops.hudi.org.apache.hadoop.hbase.replication.regionserver.SerialReplicationChecker;
import io.hops.hudi.org.apache.hadoop.hbase.replication.regionserver.WALEntryBatch;
import io.hops.hudi.org.apache.hadoop.hbase.replication.regionserver.WALEntryStream;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hadoop.hbase.wal.WAL;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class SerialReplicationSourceWALReader
extends ReplicationSourceWALReader {
    private Cell firstCellInEntryBeforeFiltering;
    private final SerialReplicationChecker checker;

    public SerialReplicationSourceWALReader(FileSystem fs, Configuration conf, ReplicationSourceLogQueue logQueue, long startPosition, WALEntryFilter filter, ReplicationSource source, String walGroupId) {
        super(fs, conf, logQueue, startPosition, filter, source, walGroupId);
        this.checker = new SerialReplicationChecker(conf, source);
    }

    @Override
    protected void readWALEntries(WALEntryStream entryStream, WALEntryBatch batch) throws IOException, InterruptedException {
        boolean hasNext;
        Path currentPath = entryStream.getCurrentPath();
        long positionBefore = entryStream.getPosition();
        do {
            WAL.Entry entry = entryStream.peek();
            boolean doFiltering = true;
            if (this.firstCellInEntryBeforeFiltering == null) {
                assert (!entry.getEdit().isEmpty()) : "should not write empty edits";
                this.firstCellInEntryBeforeFiltering = entry.getEdit().getCells().get(0);
            } else {
                doFiltering = false;
            }
            if (doFiltering) {
                entry = this.filterEntry(entry);
            }
            if (entry != null) {
                if (!this.checker.canPush(entry, this.firstCellInEntryBeforeFiltering)) {
                    if (batch.getLastWalPosition() > positionBefore) break;
                    this.checker.waitUntilCanPush(entry, this.firstCellInEntryBeforeFiltering);
                }
                batch.setLastSeqId(Bytes.toString(entry.getKey().getEncodedRegionName()), entry.getKey().getSequenceId());
                this.removeEntryFromStream(entryStream, batch);
                if (this.addEntryToBatch(batch, entry)) {
                    break;
                }
            } else {
                this.removeEntryFromStream(entryStream, batch);
            }
            hasNext = entryStream.hasNext();
            if (!SerialReplicationSourceWALReader.switched(entryStream, currentPath)) continue;
            batch.setEndOfFile(true);
            break;
        } while (hasNext);
    }

    private void removeEntryFromStream(WALEntryStream entryStream, WALEntryBatch batch) throws IOException {
        entryStream.next();
        this.firstCellInEntryBeforeFiltering = null;
        batch.setLastWalPosition(entryStream.getPosition());
    }
}

