/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.util;

import io.hops.hudi.org.apache.hadoop.hbase.TableName;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.HRegion;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import io.hops.hudi.org.apache.hadoop.hbase.util.Bytes;
import io.hops.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class HFileArchiveUtil {
    private HFileArchiveUtil() {
    }

    public static Path getStoreArchivePath(Configuration conf, TableName tableName, String regionName, String familyName) throws IOException {
        Path tableArchiveDir = HFileArchiveUtil.getTableArchivePath(conf, tableName);
        return HRegionFileSystem.getStoreHomedir(tableArchiveDir, regionName, Bytes.toBytes(familyName));
    }

    public static Path getStoreArchivePath(Configuration conf, RegionInfo region, Path tabledir, byte[] family) throws IOException {
        return HFileArchiveUtil.getStoreArchivePath(conf, region, family);
    }

    public static Path getStoreArchivePath(Configuration conf, RegionInfo region, byte[] family) throws IOException {
        Path rootDir = CommonFSUtils.getRootDir(conf);
        Path tableArchiveDir = HFileArchiveUtil.getTableArchivePath(rootDir, region.getTable());
        return HRegionFileSystem.getStoreHomedir(tableArchiveDir, region, family);
    }

    public static Path getStoreArchivePathForRootDir(Path rootDir, RegionInfo region, byte[] family) {
        Path tableArchiveDir = HFileArchiveUtil.getTableArchivePath(rootDir, region.getTable());
        return HRegionFileSystem.getStoreHomedir(tableArchiveDir, region, family);
    }

    public static Path getStoreArchivePathForArchivePath(Path archivePath, RegionInfo region, byte[] family) {
        Path tableArchiveDir = CommonFSUtils.getTableDir(archivePath, region.getTable());
        return HRegionFileSystem.getStoreHomedir(tableArchiveDir, region, family);
    }

    public static Path getRegionArchiveDir(Path rootDir, TableName tableName, Path regiondir) {
        Path archiveDir = HFileArchiveUtil.getTableArchivePath(rootDir, tableName);
        String encodedRegionName = regiondir.getName();
        return HRegion.getRegionDir(archiveDir, encodedRegionName);
    }

    public static Path getRegionArchiveDir(Path rootDir, TableName tableName, String encodedRegionName) {
        Path archiveDir = HFileArchiveUtil.getTableArchivePath(rootDir, tableName);
        return HRegion.getRegionDir(archiveDir, encodedRegionName);
    }

    public static Path getTableArchivePath(Path rootdir, TableName tableName) {
        return CommonFSUtils.getTableDir(HFileArchiveUtil.getArchivePath(rootdir), tableName);
    }

    public static Path getTableArchivePath(Configuration conf, TableName tableName) throws IOException {
        return CommonFSUtils.getTableDir(HFileArchiveUtil.getArchivePath(conf), tableName);
    }

    public static Path getArchivePath(Configuration conf) throws IOException {
        return HFileArchiveUtil.getArchivePath(CommonFSUtils.getRootDir(conf));
    }

    private static Path getArchivePath(Path rootdir) {
        return new Path(rootdir, "archive");
    }

    public static TableName getTableName(Path archivePath) {
        Path p = archivePath;
        String tbl = null;
        for (int i = 0; i < 5; ++i) {
            if (p == null) {
                return null;
            }
            if (i == 3) {
                tbl = p.getName();
            }
            p = p.getParent();
        }
        if (p == null) {
            return null;
        }
        return TableName.valueOf(p.getName(), tbl);
    }
}

