/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.hadoop.hbase.util.compaction;

import io.hops.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import io.hops.hudi.org.apache.hadoop.hbase.client.Connection;
import io.hops.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import io.hops.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import io.hops.hudi.org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import io.hops.hudi.org.apache.hadoop.hbase.util.compaction.MajorCompactionRequest;
import io.hops.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.hadoop.conf.Configuration;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MajorCompactionTTLRequest
extends MajorCompactionRequest {
    private static final Logger LOG = LoggerFactory.getLogger(MajorCompactionTTLRequest.class);

    MajorCompactionTTLRequest(Configuration conf, RegionInfo region) {
        super(conf, region);
    }

    static Optional<MajorCompactionRequest> newRequest(Configuration conf, RegionInfo info, TableDescriptor htd) throws IOException {
        MajorCompactionTTLRequest request = new MajorCompactionTTLRequest(conf, info);
        return request.createRequest(conf, htd);
    }

    private Optional<MajorCompactionRequest> createRequest(Configuration conf, TableDescriptor htd) throws IOException {
        Map<String, Long> familiesToCompact = this.getStoresRequiringCompaction(htd);
        MajorCompactionTTLRequest request = null;
        if (!familiesToCompact.isEmpty()) {
            LOG.debug("Compaction families for region: " + this.region + " CF: " + familiesToCompact.keySet());
            request = new MajorCompactionTTLRequest(conf, this.region);
        }
        return Optional.ofNullable(request);
    }

    Map<String, Long> getStoresRequiringCompaction(TableDescriptor htd) throws IOException {
        try (Connection connection = this.getConnection(this.configuration);){
            HRegionFileSystem fileSystem2 = this.getFileSystem(connection);
            HashMap<String, Long> familyTTLMap = Maps.newHashMap();
            for (ColumnFamilyDescriptor descriptor : htd.getColumnFamilies()) {
                long ts = this.getColFamilyCutoffTime(descriptor);
                if (ts <= 0L || !this.shouldCFBeCompacted(fileSystem2, descriptor.getNameAsString(), ts)) continue;
                familyTTLMap.put(descriptor.getNameAsString(), ts);
            }
            HashMap<String, Long> hashMap = familyTTLMap;
            return hashMap;
        }
    }

    private long getColFamilyCutoffTime(ColumnFamilyDescriptor colDesc) {
        if (colDesc.getTimeToLive() == Integer.MAX_VALUE) {
            return -1L;
        }
        return System.currentTimeMillis() - (long)colDesc.getTimeToLive() * 1000L;
    }

    @Override
    protected boolean shouldIncludeStore(HRegionFileSystem fileSystem2, String family, Collection<StoreFileInfo> storeFiles, long ts) throws IOException {
        for (StoreFileInfo storeFile : storeFiles) {
            if (storeFile.getModificationTime() < ts) continue;
            LOG.info("There is atleast one file in store: " + family + " file: " + storeFile.getPath() + " with timestamp " + storeFile.getModificationTime() + " for region: " + fileSystem2.getRegionInfo().getEncodedName() + " older than TTL: " + ts);
            return false;
        }
        return true;
    }
}

