/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.http.protocol;

import io.hops.hudi.org.apache.http.HttpException;
import io.hops.hudi.org.apache.http.HttpRequest;
import io.hops.hudi.org.apache.http.HttpRequestInterceptor;
import io.hops.hudi.org.apache.http.annotation.Immutable;
import io.hops.hudi.org.apache.http.params.HttpParams;
import io.hops.hudi.org.apache.http.protocol.HttpContext;
import io.hops.hudi.org.apache.http.util.Args;
import java.io.IOException;

@Immutable
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (!request.containsHeader("User-Agent")) {
            String s = null;
            HttpParams params = request.getParams();
            if (params != null) {
                s = (String)params.getParameter("http.useragent");
            }
            if (s == null) {
                s = this.userAgent;
            }
            if (s != null) {
                request.addHeader("User-Agent", s);
            }
        }
    }
}

