/*
 * Decompiled with CFR 0.152.
 */
package io.hops.hudi.org.apache.jetty.websocket.common.message;

import io.hops.hudi.org.apache.jetty.io.ByteBufferPool;
import io.hops.hudi.org.apache.jetty.io.NullByteBufferPool;
import io.hops.hudi.org.apache.jetty.util.BufferUtil;
import io.hops.hudi.org.apache.jetty.util.log.Log;
import io.hops.hudi.org.apache.jetty.util.log.Logger;
import io.hops.hudi.org.apache.jetty.websocket.api.Session;
import io.hops.hudi.org.apache.jetty.websocket.api.SuspendToken;
import io.hops.hudi.org.apache.jetty.websocket.common.WebSocketSession;
import io.hops.hudi.org.apache.jetty.websocket.common.message.MessageAppender;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class MessageInputStream
extends InputStream
implements MessageAppender {
    private static final Logger LOG = Log.getLogger(MessageInputStream.class);
    private static final ByteBuffer EOF = ByteBuffer.allocate(0).asReadOnlyBuffer();
    private final Session session;
    private final ByteBufferPool bufferPool;
    private final BlockingDeque<ByteBuffer> buffers = new LinkedBlockingDeque<ByteBuffer>();
    private final long timeoutMs;
    private ByteBuffer activeBuffer = null;
    private SuspendToken suspendToken;
    private State state = State.RESUMED;

    public MessageInputStream(Session session) {
        this(session, -1);
    }

    public MessageInputStream(Session session, int timeoutMs) {
        this.timeoutMs = timeoutMs;
        this.session = session;
        this.bufferPool = session instanceof WebSocketSession ? ((WebSocketSession)session).getBufferPool() : new NullByteBufferPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendFrame(ByteBuffer framePayload, boolean fin) throws IOException {
        boolean bufferIsEmpty;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Appending {} chunk: {}", fin ? "final" : "non-final", BufferUtil.toDetailString(framePayload));
        }
        if ((bufferIsEmpty = BufferUtil.isEmpty(framePayload)) && !fin) {
            return;
        }
        try {
            MessageInputStream messageInputStream = this;
            synchronized (messageInputStream) {
                if (!bufferIsEmpty) {
                    switch (this.state) {
                        case CLOSED: {
                            return;
                        }
                        case RESUMED: {
                            this.suspendToken = this.session.suspend();
                            this.state = State.SUSPENDED;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Incorrect State: " + this.state.name());
                        }
                    }
                    ByteBuffer copy = this.acquire(framePayload.remaining(), framePayload.isDirect());
                    BufferUtil.clearToFill(copy);
                    copy.put(framePayload);
                    BufferUtil.flipToFlush(copy, 0);
                    this.buffers.put(copy);
                }
                if (fin) {
                    this.buffers.add(EOF);
                    this.state = State.COMPLETE;
                }
            }
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        MessageInputStream messageInputStream = this;
        synchronized (messageInputStream) {
            boolean remainingContent;
            if (this.state == State.CLOSED) {
                return;
            }
            boolean bl = remainingContent = this.state != State.COMPLETE || !this.buffers.isEmpty() && this.buffers.peek() != EOF || this.activeBuffer != null && this.activeBuffer.hasRemaining();
            if (remainingContent) {
                LOG.warn("MessageInputStream closed without fully consuming content {}", this.session);
            }
            if (this.activeBuffer != null && this.activeBuffer != EOF) {
                this.bufferPool.release(this.activeBuffer);
            }
            for (ByteBuffer buffer : this.buffers) {
                if (buffer == null || buffer == EOF) continue;
                this.bufferPool.release(buffer);
            }
            this.activeBuffer = null;
            this.buffers.clear();
            this.state = State.CLOSED;
            this.buffers.add(EOF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlerComplete() {
        SuspendToken resume;
        this.close();
        MessageInputStream messageInputStream = this;
        synchronized (messageInputStream) {
            resume = this.suspendToken;
            this.suspendToken = null;
        }
        if (resume != null) {
            resume.resume();
        }
    }

    @Override
    public int read() throws IOException {
        int read;
        byte[] bytes = new byte[1];
        do {
            if ((read = this.read(bytes, 0, 1)) >= 0) continue;
            return -1;
        } while (read == 0);
        return bytes[0] & 0xFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            if (this.state == State.CLOSED) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Stream closed", new Object[0]);
                }
                return -1;
            }
            while (this.activeBuffer == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Waiting {} ms to read", this.timeoutMs);
                }
                if (this.timeoutMs < 0L) {
                    this.activeBuffer = this.buffers.take();
                } else {
                    this.activeBuffer = this.buffers.poll(this.timeoutMs, TimeUnit.MILLISECONDS);
                    if (this.activeBuffer == null) {
                        throw new IOException(String.format("Read timeout: %,dms expired", this.timeoutMs));
                    }
                }
                if (this.activeBuffer != EOF) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Reached EOF", new Object[0]);
                }
                this.close();
                return -1;
            }
            ByteBuffer buffer = BufferUtil.toBuffer(b, off, len);
            BufferUtil.clearToFill(buffer);
            int written = BufferUtil.put(this.activeBuffer, buffer);
            BufferUtil.flipToFlush(buffer, 0);
            if (!this.activeBuffer.hasRemaining()) {
                SuspendToken resume = null;
                MessageInputStream messageInputStream = this;
                synchronized (messageInputStream) {
                    if (this.activeBuffer != null && this.activeBuffer != EOF) {
                        this.bufferPool.release(this.activeBuffer);
                    }
                    this.activeBuffer = null;
                    switch (this.state) {
                        case CLOSED: {
                            return -1;
                        }
                        case COMPLETE: {
                            break;
                        }
                        case SUSPENDED: {
                            resume = this.suspendToken;
                            this.suspendToken = null;
                            this.state = State.RESUMED;
                            break;
                        }
                        case RESUMED: {
                            throw new IllegalStateException("Incorrect State: " + this.state.name());
                        }
                    }
                }
                if (resume != null) {
                    resume.resume();
                }
            }
            return written;
        }
        catch (InterruptedException x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Interrupted while waiting to read", x);
            }
            this.close();
            return -1;
        }
    }

    @Override
    public void messageComplete() {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException("reset() not supported");
    }

    @Override
    public void mark(int readlimit) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    private ByteBuffer acquire(int capacity, boolean direct) {
        return this.bufferPool.acquire(capacity, direct);
    }

    private static enum State {
        RESUMED,
        SUSPENDED,
        COMPLETE,
        CLOSED;

    }
}

