/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import io.hops.hudi.org.apache.spark.sql.avro.HoodieAvroDeserializer;
import io.hops.hudi.org.apache.spark.sql.avro.HoodieAvroSchemaConverters;
import io.hops.hudi.org.apache.spark.sql.avro.HoodieAvroSerializer;
import java.io.Serializable;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.utils.SparkRowSerDe;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class AvroConversionUtils$ {
    public static AvroConversionUtils$ MODULE$;

    static {
        new AvroConversionUtils$();
    }

    public Tuple2<Object, Schema> resolveAvroTypeNullability(Schema avroType) {
        Tuple2 tuple2;
        Schema.Type type = avroType.getType();
        Schema.Type type2 = Schema.Type.UNION;
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            Buffer fields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(avroType.getTypes()).asScala();
            Buffer actualType = (Buffer)fields.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AvroConversionUtils$.$anonfun$resolveAvroTypeNullability$1(x$1)));
            if (fields.length() != 2 || actualType.length() != 1) {
                throw new AvroRuntimeException(new StringBuilder(88).append("Unsupported Avro UNION type ").append(avroType).append(": Only UNION of a null type and a non-null ").append("type is supported").toString());
            }
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), actualType.head());
        } else {
            tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)avroType);
        }
        return tuple2;
    }

    public Function1<GenericRecord, Option<InternalRow>> createAvroToInternalRowConverter(Schema rootAvroType, StructType rootCatalystType) {
        HoodieAvroDeserializer deserializer = HoodieSparkUtils$.MODULE$.sparkAdapter().createAvroDeserializer(rootAvroType, (DataType)rootCatalystType);
        return (Function1 & Serializable & scala.Serializable)record -> deserializer.deserialize(record).map((Function1 & Serializable & scala.Serializable)x$2 -> (InternalRow)x$2);
    }

    public Function1<InternalRow, GenericRecord> createInternalRowToAvroConverter(StructType rootCatalystType, Schema rootAvroType, boolean nullable) {
        HoodieAvroSerializer serializer = HoodieSparkUtils$.MODULE$.sparkAdapter().createAvroSerializer((DataType)rootCatalystType, rootAvroType, nullable);
        return (Function1 & Serializable & scala.Serializable)row -> (GenericRecord)serializer.serialize(row);
    }

    @Deprecated
    public Function1<GenericRecord, Row> createConverterToRow(Schema sourceAvroSchema, StructType targetSqlType) {
        SparkRowSerDe serde = HoodieSparkUtils$.MODULE$.sparkAdapter().createSparkRowSerDe(targetSqlType);
        Function1<GenericRecord, Option<InternalRow>> converter = this.createAvroToInternalRowConverter(sourceAvroSchema, targetSqlType);
        return (Function1 & Serializable & scala.Serializable)avro -> (Row)((Option)converter.apply(avro)).map((Function1 & Serializable & scala.Serializable)internalRow -> serde.deserializeRow((InternalRow)internalRow)).get();
    }

    @Deprecated
    public Function1<Row, GenericRecord> createConverterToAvro(StructType sourceSqlType, String structName, String recordNamespace) {
        boolean nullable;
        SparkRowSerDe serde = HoodieSparkUtils$.MODULE$.sparkAdapter().createSparkRowSerDe(sourceSqlType);
        Schema avroSchema = this.convertStructTypeToAvroSchema((DataType)sourceSqlType, structName, recordNamespace);
        Tuple2<Object, Schema> tuple2 = this.resolveAvroTypeNullability(avroSchema);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        boolean bl = nullable = tuple2._1$mcZ$sp();
        boolean nullable2 = bl;
        Function1<InternalRow, GenericRecord> converter = this.createInternalRowToAvroConverter(sourceSqlType, avroSchema, nullable2);
        return (Function1 & Serializable & scala.Serializable)row -> (GenericRecord)converter.apply((Object)serde.serializeRow((Row)row));
    }

    public Dataset<Row> createDataFrame(RDD<GenericRecord> rdd, String schemaStr, SparkSession ss) {
        return rdd.isEmpty() ? ss.emptyDataFrame() : ss.createDataFrame(rdd.mapPartitions((Function1 & Serializable & scala.Serializable)records -> {
            Iterator iterator2;
            if (records.isEmpty()) {
                iterator2 = package$.MODULE$.Iterator().empty();
            } else {
                Schema schema = new Schema.Parser().parse(schemaStr);
                StructType dataType = MODULE$.convertAvroSchemaToStructType(schema);
                Function1<GenericRecord, Row> converter = MODULE$.createConverterToRow(schema, dataType);
                iterator2 = records.map((Function1 & Serializable & scala.Serializable)r -> (Row)converter.apply(r));
            }
            return iterator2;
        }, rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Row.class)), this.convertAvroSchemaToStructType(new Schema.Parser().parse(schemaStr)));
    }

    public Schema convertStructTypeToAvroSchema(DataType structType, String structName, String recordNamespace) {
        HoodieAvroSchemaConverters schemaConverters = HoodieSparkUtils$.MODULE$.sparkAdapter().getAvroSchemaConverters();
        Schema avroSchema = schemaConverters.toAvroType(structType, false, structName, recordNamespace);
        return this.getAvroSchemaWithDefaults(avroSchema, structType);
    }

    public StructType convertAvroSchemaToStructType(Schema avroSchema) {
        HoodieAvroSchemaConverters schemaConverters = HoodieSparkUtils$.MODULE$.sparkAdapter().getAvroSchemaConverters();
        Tuple2<DataType, Object> tuple2 = schemaConverters.toSqlType(avroSchema);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        DataType dataType = (DataType)tuple2._1();
        StructType structType = (StructType)dataType;
        return structType;
    }

    public Schema getAvroSchemaWithDefaults(Schema schema, DataType dataType) {
        Schema schema2;
        Schema.Type type = schema.getType();
        if (Schema.Type.RECORD.equals(type)) {
            StructType structType = (StructType)dataType;
            StructField[] structFields = structType.fields();
            List modifiedFields = ((TraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(schema.getFields()).map((Function1 & Serializable & scala.Serializable)field -> {
                Schema.Field field2;
                int i = structType.fieldIndex(field.name());
                String comment = structFields[i].metadata().contains("comment") ? structFields[i].metadata().getString("comment") : field.doc();
                Schema newSchema = MODULE$.getAvroSchemaWithDefaults(field.schema(), structFields[i].dataType());
                Schema.Type type = field.schema().getType();
                if (Schema.Type.UNION.equals(type)) {
                    Schema.Field field3;
                    java.util.List innerFields = newSchema.getTypes();
                    boolean containsNullSchema = BoxesRunTime.unboxToBoolean((Object)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(innerFields).foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2 & Serializable & scala.Serializable)(nullFieldEncountered, schema) -> BoxesRunTime.boxToBoolean((boolean)AvroConversionUtils$.$anonfun$getAvroSchemaWithDefaults$2(BoxesRunTime.unboxToBoolean((Object)nullFieldEncountered), schema))));
                    if (containsNullSchema) {
                        Schema restructuredNewSchema = Schema.createUnion((java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)new .colon.colon((Object)Schema.create((Schema.Type)Schema.Type.NULL), (List)Nil$.MODULE$).$plus$plus((GenTraversableOnce)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(innerFields).filter((Function1 & Serializable & scala.Serializable)innerSchema -> BoxesRunTime.boxToBoolean((boolean)AvroConversionUtils$.$anonfun$getAvroSchemaWithDefaults$3(innerSchema))), List$.MODULE$.canBuildFrom())));
                        field3 = new Schema.Field(field.name(), restructuredNewSchema, comment, (Object)JsonProperties.NULL_VALUE);
                    } else {
                        field3 = new Schema.Field(field.name(), newSchema, comment, field.defaultVal());
                    }
                    field2 = field3;
                } else {
                    field2 = new Schema.Field(field.name(), newSchema, comment, field.defaultVal());
                }
                return field2;
            }, Buffer$.MODULE$.canBuildFrom())).toList();
            schema2 = Schema.createRecord((String)schema.getName(), (String)schema.getDoc(), (String)schema.getNamespace(), (boolean)schema.isError(), (java.util.List)JavaConversions$.MODULE$.deprecated$u0020seqAsJavaList((Seq)modifiedFields));
        } else {
            schema2 = Schema.Type.UNION.equals(type) ? Schema.createUnion((java.util.List)JavaConversions$.MODULE$.deprecated$u0020bufferAsJavaList((Buffer)JavaConversions$.MODULE$.deprecated$u0020asScalaBuffer(schema.getTypes()).map((Function1 & Serializable & scala.Serializable)innerSchema -> MODULE$.getAvroSchemaWithDefaults((Schema)innerSchema, dataType), Buffer$.MODULE$.canBuildFrom()))) : (Schema.Type.MAP.equals(type) ? Schema.createMap((Schema)this.getAvroSchemaWithDefaults(schema.getValueType(), ((MapType)dataType).valueType())) : (Schema.Type.ARRAY.equals(type) ? Schema.createArray((Schema)this.getAvroSchemaWithDefaults(schema.getElementType(), ((ArrayType)dataType).elementType())) : schema));
        }
        return schema2;
    }

    public Tuple2<String, String> getAvroRecordNameAndNamespace(String tableName) {
        String name = HoodieAvroUtils.sanitizeName(tableName);
        return new Tuple2((Object)new StringBuilder(7).append(name).append("_record").toString(), (Object)new StringBuilder(7).append("hoodie.").append(name).toString());
    }

    public static final /* synthetic */ boolean $anonfun$resolveAvroTypeNullability$1(Schema x$1) {
        Schema.Type type = x$1.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    public static final /* synthetic */ boolean $anonfun$getAvroSchemaWithDefaults$2(boolean nullFieldEncountered, Schema schema) {
        Schema.Type type = schema.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return nullFieldEncountered | !(type != null ? !type.equals(type2) : type2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$getAvroSchemaWithDefaults$3(Schema innerSchema) {
        Schema.Type type = innerSchema.getType();
        Schema.Type type2 = Schema.Type.NULL;
        return type == null ? type2 != null : !type.equals(type2);
    }

    private AvroConversionUtils$() {
        MODULE$ = this;
    }
}

