/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieMergeOnReadFileSplit;
import org.apache.hudi.HoodieTableState;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadata;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class HoodieMergeOnReadRDD$
implements scala.Serializable {
    public static HoodieMergeOnReadRDD$ MODULE$;
    private final Object CONFIG_INSTANTIATION_LOCK;

    static {
        new HoodieMergeOnReadRDD$();
    }

    public Object CONFIG_INSTANTIATION_LOCK() {
        return this.CONFIG_INSTANTIATION_LOCK;
    }

    public HoodieMergedLogRecordScanner scanLog(List<HoodieLogFile> logFiles, Path partitionPath, Schema logSchema, HoodieTableState tableState, long maxCompactionMemoryInBytes, Configuration hadoopConf, InternalSchema internalSchema) {
        HoodieMergedLogRecordScanner hoodieMergedLogRecordScanner;
        String tablePath = tableState.tablePath();
        FileSystem fs = FSUtils.getFs(tablePath, hadoopConf);
        if (HoodieTableMetadata.isMetadataTable(tablePath)) {
            HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties(tableState.metadataConfig().getProps()).enable(true).build();
            String dataTableBasePath = HoodieTableMetadata.getDataTableBasePathFromMetadataTable(tablePath);
            HoodieBackedTableMetadata metadataTable = new HoodieBackedTableMetadata(new HoodieLocalEngineContext(hadoopConf), metadataConfig, dataTableBasePath, hadoopConf.get("hoodie.memory.spillable.map.path", "/tmp/"));
            boolean forceFullScan = true;
            String relativePartitionPath = FSUtils.getRelativePartitionPath(new Path(tablePath), partitionPath);
            hoodieMergedLogRecordScanner = metadataTable.getLogRecordScanner((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(logFiles).asJava(), relativePartitionPath, HoodieConversionUtils$.MODULE$.toJavaOption(new Some((Object)Predef$.MODULE$.boolean2Boolean(forceFullScan)))).getLeft();
        } else {
            HoodieMergedLogRecordScanner.Builder logRecordScannerBuilder = ((HoodieMergedLogRecordScanner.Builder)HoodieMergedLogRecordScanner.newBuilder().withFileSystem(fs).withBasePath(tablePath).withLogFilePaths((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)logFiles.map((Function1 & Serializable & scala.Serializable)logFile -> logFile.getPath().toString(), List$.MODULE$.canBuildFrom())).asJava())).withReaderSchema(logSchema).withLatestInstantTime(tableState.latestCommitTimestamp()).withReadBlocksLazily(BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(hadoopConf.get("compaction.lazy.block.read.enabled", "true"))).toBoolean()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> false))).withReverseReader(false).withInternalSchema(internalSchema).withBufferSize(hadoopConf.getInt("hoodie.memory.dfs.buffer.max.size", 0x100000)).withMaxMemorySizeInBytes(Predef$.MODULE$.long2Long(maxCompactionMemoryInBytes)).withSpillableMapBasePath(hadoopConf.get("hoodie.memory.spillable.map.path", "/tmp/")).withDiskMapType((ExternalSpillableMap.DiskMapType)hadoopConf.getEnum(HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), (Enum)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.defaultValue())).withBitCaskDiskMapCompressionEnabled(hadoopConf.getBoolean(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.key(), Predef$.MODULE$.Boolean2boolean(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.defaultValue())));
            Object object = logFiles.nonEmpty() ? logRecordScannerBuilder.withPartition(FSUtils.getRelativePartitionPath(new Path(tableState.tablePath()), ((HoodieLogFile)logFiles.head()).getPath().getParent())) : BoxedUnit.UNIT;
            hoodieMergedLogRecordScanner = logRecordScannerBuilder.build();
        }
        return hoodieMergedLogRecordScanner;
    }

    public InternalSchema scanLog$default$7() {
        return InternalSchema.getEmptyInternalSchema();
    }

    public GenericRecord org$apache$hudi$HoodieMergeOnReadRDD$$projectAvroUnsafe(GenericRecord record, Schema projectedSchema, GenericRecordBuilder reusableRecordBuilder) {
        Buffer fields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(projectedSchema.getFields()).asScala();
        fields.foreach((Function1 & Serializable & scala.Serializable)field -> reusableRecordBuilder.set(field, record.get(field.name())));
        return reusableRecordBuilder.build();
    }

    public Path org$apache$hudi$HoodieMergeOnReadRDD$$getPartitionPath(HoodieMergeOnReadFileSplit split) {
        return ((Path)split.dataFile().map((Function1 & Serializable & scala.Serializable)baseFile -> new Path(baseFile.filePath())).getOrElse((Function0 & Serializable & scala.Serializable)() -> ((HoodieLogFile)split.logFiles().head()).getPath())).getParent();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HoodieMergeOnReadRDD$() {
        MODULE$ = this;
        this.CONFIG_INSTANTIATION_LOCK = new Object();
    }
}

