/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.fs;

import java.util.Arrays;

public enum StorageSchemes {
    FILE("file", false),
    HDFS("hdfs", true),
    HOPSFS("hopsfs", true),
    AFS("afs", true),
    MAPRFS("maprfs", true),
    IGNITE("igfs", true),
    S3A("s3a", false),
    S3("s3", false),
    GCS("gs", false),
    WASB("wasb", false),
    WASBS("wasbs", false),
    ADL("adl", false),
    ABFS("abfs", false),
    ABFSS("abfss", false),
    OSS("oss", false),
    VIEWFS("viewfs", true),
    ALLUXIO("alluxio", false),
    COSN("cosn", false),
    CHDFS("ofs", true),
    GOOSEFS("gfs", false),
    DBFS("dbfs", false),
    COS("cos", false),
    OBS("obs", false),
    KS3("ks3", false),
    JFS("jfs", true),
    BOS("bos", false),
    OCI("oci", false);

    private String scheme;
    private boolean supportsAppend;

    private StorageSchemes(String scheme2, boolean supportsAppend) {
        this.scheme = scheme2;
        this.supportsAppend = supportsAppend;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean supportsAppend() {
        return this.supportsAppend;
    }

    public static boolean isSchemeSupported(String scheme2) {
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.getScheme().equals(scheme2));
    }

    public static boolean isAppendSupported(String scheme2) {
        if (!StorageSchemes.isSchemeSupported(scheme2)) {
            throw new IllegalArgumentException("Unsupported scheme :" + scheme2);
        }
        return Arrays.stream(StorageSchemes.values()).anyMatch(s -> s.supportsAppend() && s.scheme.equals(scheme2));
    }
}

