/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.execution.bulkinsert.BulkInsertSortMode;
import org.apache.hudi.execution.bulkinsert.GlobalSortPartitioner;
import org.apache.hudi.execution.bulkinsert.NonSortPartitioner;
import org.apache.hudi.execution.bulkinsert.PartitionPathRepartitionAndSortPartitioner;
import org.apache.hudi.execution.bulkinsert.PartitionPathRepartitionPartitioner;
import org.apache.hudi.execution.bulkinsert.RDDPartitionSortPartitioner;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;

public abstract class BulkInsertInternalPartitionerFactory {
    public static BulkInsertPartitioner get(HoodieTable table, HoodieWriteConfig config) {
        return BulkInsertInternalPartitionerFactory.get(config.getBulkInsertSortMode(), table.isPartitioned(), false);
    }

    public static BulkInsertPartitioner get(HoodieTable table, HoodieWriteConfig config, boolean enforceNumOutputPartitions) {
        return BulkInsertInternalPartitionerFactory.get(config.getBulkInsertSortMode(), table.isPartitioned(), enforceNumOutputPartitions);
    }

    public static BulkInsertPartitioner get(BulkInsertSortMode sortMode, boolean isTablePartitioned) {
        return BulkInsertInternalPartitionerFactory.get(sortMode, isTablePartitioned, false);
    }

    public static BulkInsertPartitioner get(BulkInsertSortMode sortMode, boolean isTablePartitioned, boolean enforceNumOutputPartitions) {
        switch (sortMode) {
            case NONE: {
                return new NonSortPartitioner(enforceNumOutputPartitions);
            }
            case GLOBAL_SORT: {
                return new GlobalSortPartitioner();
            }
            case PARTITION_SORT: {
                return new RDDPartitionSortPartitioner();
            }
            case PARTITION_PATH_REPARTITION: {
                return new PartitionPathRepartitionPartitioner(isTablePartitioned);
            }
            case PARTITION_PATH_REPARTITION_AND_SORT: {
                return new PartitionPathRepartitionAndSortPartitioner(isTablePartitioned);
            }
        }
        throw new HoodieException("The bulk insert sort mode \"" + sortMode.name() + "\" is not supported.");
    }
}

