/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution.bulkinsert;

import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class PartitionPathRepartitionAndSortPartitionerWithRows
implements BulkInsertPartitioner<Dataset<Row>> {
    private final boolean isTablePartitioned;

    public PartitionPathRepartitionAndSortPartitionerWithRows(boolean isTablePartitioned) {
        this.isTablePartitioned = isTablePartitioned;
    }

    @Override
    public Dataset<Row> repartitionRecords(Dataset<Row> rows, int outputSparkPartitions) {
        if (this.isTablePartitioned) {
            return rows.repartition(outputSparkPartitions, new Column[]{new Column("_hoodie_partition_path")}).sortWithinPartitions(new Column[]{new Column("_hoodie_partition_path")});
        }
        return rows.coalesce(outputSparkPartitions);
    }

    @Override
    public boolean arePartitionRecordsSorted() {
        return this.isTablePartitioned;
    }
}

