/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.CreateHandleFactory;
import org.apache.hudi.io.HoodieUnboundedCreateHandle;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.table.HoodieTable;

public class SingleFileHandleCreateFactory<T extends HoodieRecordPayload, I, K, O>
extends CreateHandleFactory<T, I, K, O>
implements Serializable {
    private final AtomicBoolean isHandleCreated = new AtomicBoolean(false);
    private final String fileId;
    private final boolean preserveHoodieMetadata;

    public SingleFileHandleCreateFactory(String fileId, boolean preserveHoodieMetadata) {
        this.fileId = fileId;
        this.preserveHoodieMetadata = preserveHoodieMetadata;
    }

    @Override
    public HoodieWriteHandle<T, I, K, O> create(HoodieWriteConfig hoodieConfig, String commitTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileIdPrefix, TaskContextSupplier taskContextSupplier) {
        if (this.isHandleCreated.compareAndSet(false, true)) {
            return new HoodieUnboundedCreateHandle<T, I, K, O>(hoodieConfig, commitTime, hoodieTable, partitionPath, this.fileId, taskContextSupplier, this.preserveHoodieMetadata);
        }
        throw new HoodieIOException("Fixed handle create is only expected to be invoked once");
    }
}

