/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.prometheus;

import io.hops.hudi.com.codahale.metrics.MetricFilter;
import io.hops.hudi.com.codahale.metrics.MetricRegistry;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.hudi.metrics.prometheus.PushGatewayReporter;

public class PushGatewayMetricsReporter
extends MetricsReporter {
    private final PushGatewayReporter pushGatewayReporter;
    private final int periodSeconds;
    private final boolean deleteShutdown;
    private final String configuredJobName;
    private final boolean randomSuffix;

    public PushGatewayMetricsReporter(HoodieWriteConfig config, MetricRegistry registry) {
        String serverHost = config.getPushGatewayHost();
        int serverPort = config.getPushGatewayPort();
        this.periodSeconds = config.getPushGatewayReportPeriodSeconds();
        this.deleteShutdown = config.getPushGatewayDeleteOnShutdown();
        this.configuredJobName = config.getPushGatewayJobName();
        this.randomSuffix = config.getPushGatewayRandomJobNameSuffix();
        this.pushGatewayReporter = new PushGatewayReporter(registry, MetricFilter.ALL, TimeUnit.SECONDS, TimeUnit.SECONDS, this.getJobName(), serverHost, serverPort, this.deleteShutdown);
    }

    @Override
    public void start() {
        this.pushGatewayReporter.start(this.periodSeconds, TimeUnit.SECONDS);
    }

    @Override
    public void report() {
        this.pushGatewayReporter.report(null, null, null, null, null);
    }

    @Override
    public void stop() {
        this.pushGatewayReporter.stop();
    }

    private String getJobName() {
        if (this.randomSuffix) {
            Random random = new Random();
            return this.configuredJobName + random.nextLong();
        }
        return this.configuredJobName;
    }
}

