/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.prometheus;

import io.hops.hudi.com.codahale.metrics.Counter;
import io.hops.hudi.com.codahale.metrics.Gauge;
import io.hops.hudi.com.codahale.metrics.Histogram;
import io.hops.hudi.com.codahale.metrics.Meter;
import io.hops.hudi.com.codahale.metrics.MetricFilter;
import io.hops.hudi.com.codahale.metrics.MetricRegistry;
import io.hops.hudi.com.codahale.metrics.ScheduledReporter;
import io.hops.hudi.com.codahale.metrics.Timer;
import io.hops.hudi.io.prometheus.client.CollectorRegistry;
import io.hops.hudi.io.prometheus.client.dropwizard.DropwizardExports;
import io.hops.hudi.io.prometheus.client.exporter.PushGateway;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class PushGatewayReporter
extends ScheduledReporter {
    private static final Logger LOG = LogManager.getLogger(PushGatewayReporter.class);
    private final PushGateway pushGateway;
    private final DropwizardExports metricExports;
    private final CollectorRegistry collectorRegistry;
    private final String jobName;
    private final boolean deleteShutdown;

    protected PushGatewayReporter(MetricRegistry registry, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, String jobName, String serverHost, int serverPort, boolean deleteShutdown) {
        super(registry, "hudi-push-gateway-reporter", filter, rateUnit, durationUnit);
        this.jobName = jobName;
        this.deleteShutdown = deleteShutdown;
        this.collectorRegistry = new CollectorRegistry();
        this.metricExports = new DropwizardExports(registry);
        this.pushGateway = this.createPushGatewayClient(serverHost, serverPort);
        this.metricExports.register(this.collectorRegistry);
    }

    private PushGateway createPushGatewayClient(String serverHost, int serverPort) {
        if (serverPort == 443) {
            try {
                return new PushGateway(new URL("https://" + serverHost + ":" + serverPort));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
                throw new IllegalArgumentException("Malformed pushgateway host: " + serverHost);
            }
        }
        return new PushGateway(serverHost + ":" + serverPort);
    }

    @Override
    public void report(SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        try {
            this.pushGateway.pushAdd(this.collectorRegistry, this.jobName);
        }
        catch (IOException e) {
            LOG.warn((Object)"Can't push monitoring information to pushGateway", (Throwable)e);
        }
    }

    @Override
    public void start(long period, TimeUnit unit) {
        super.start(period, unit);
    }

    @Override
    public void stop() {
        super.stop();
        try {
            if (this.deleteShutdown) {
                this.collectorRegistry.unregister(this.metricExports);
                this.pushGateway.delete(this.jobName);
            }
        }
        catch (IOException e) {
            LOG.warn((Object)("Failed to delete metrics from pushGateway with jobName {" + this.jobName + "}"), (Throwable)e);
        }
    }
}

